'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}jQuery.Class("Vtiger_RelatedList_Js",{relatedListInstance:!1,getInstance:function getInstance(parentId,parentModule,selectedRelatedTabElement,relatedModuleName,url){if(!1===Vtiger_RelatedList_Js.relatedListInstance||Vtiger_RelatedList_Js.relatedListInstance.moduleName!==relatedModuleName){var instance,moduleClassName=app.getModuleName()+"_RelatedList_Js",fallbackClassName=Vtiger_RelatedList_Js;instance="undefined"==typeof window[moduleClassName]?new fallbackClassName:new window[moduleClassName],instance.parentRecordId=parentId,instance.parentModuleName=parentModule,instance.selectedRelatedTabElement=selectedRelatedTabElement,instance.moduleName=relatedModuleName,instance.relatedTabsContainer=selectedRelatedTabElement.closest("div.related"),instance.content=$("div.contents",instance.relatedTabsContainer.closest("div.detailViewContainer")),instance.relatedView=instance.content.find("input.relatedView").val(),Vtiger_RelatedList_Js.relatedListInstance=instance;}return Vtiger_RelatedList_Js.relatedListInstance.parseUrlParams(url),Vtiger_RelatedList_Js.relatedListInstance.setSelectedTabElement(selectedRelatedTabElement),Vtiger_RelatedList_Js.relatedListInstance},getInstanceByUrl:function getInstanceByUrl(url,selectedRelatedTabElement){var params=app.convertUrlToObject(url);if(!1===Vtiger_RelatedList_Js.relatedListInstance||Vtiger_RelatedList_Js.relatedListInstance.moduleName!==params.relatedModule){var instance,moduleClassName=app.getModuleName()+"_RelatedList_Js",fallbackClassName=Vtiger_RelatedList_Js;instance="undefined"==typeof window[moduleClassName]?new fallbackClassName:new window[moduleClassName],instance.selectedRelatedTabElement=selectedRelatedTabElement,instance.relatedTabsContainer=selectedRelatedTabElement.closest("div.related"),instance.content=$("div.contents",instance.relatedTabsContainer.closest("div.detailViewContainer")),instance.relatedView=instance.content.find("input.relatedView").val(),Vtiger_RelatedList_Js.relatedListInstance=instance;}return Vtiger_RelatedList_Js.relatedListInstance.parentRecordId=params.record,Vtiger_RelatedList_Js.relatedListInstance.parentModuleName=params.module,Vtiger_RelatedList_Js.relatedListInstance.moduleName=params.relatedModule,Vtiger_RelatedList_Js.relatedListInstance.defaultParams=params,Vtiger_RelatedList_Js.relatedListInstance.setSelectedTabElement(selectedRelatedTabElement),Vtiger_RelatedList_Js.relatedListInstance},triggerMassAction:function triggerMassAction(massActionUrl,type){var self=this.relatedListInstance,validationResult=self.checkListRecordSelected();if(!0!=validationResult){var progressIndicatorElement=$.progressIndicator(),selectedIds=self.readSelectedIds(!0),excludedIds=self.readExcludedIds(!0),cvId=self.getCurrentCvId(),postData=self.getCompleteParams();delete postData.mode,delete postData.view,postData.viewname=cvId,postData.selected_ids=selectedIds,postData.excluded_ids=excludedIds;"sendByForm"===type?(AppConnector.requestForm(massActionUrl,postData),progressIndicatorElement.progressIndicator({mode:"hide"})):AppConnector.request({type:"POST",url:massActionUrl,data:postData}).done(function(responseData){if(progressIndicatorElement.progressIndicator({mode:"hide"}),responseData&&null!==responseData.result&&(responseData.result.notify&&Vtiger_Helper_Js.showMessage(responseData.result.notify),responseData.result.reloadList&&Vtiger_Detail_Js.reloadRelatedList(),responseData.result.processStop))return progressIndicatorElement.progressIndicator({mode:"hide"}),!1}).fail(function(){progressIndicatorElement.progressIndicator({mode:"hide"});});}else self.noRecordSelectedAlert();},/**
		 * Method to verify if selected files exist
		 * @return boolean
		 */verifyFileExist:function verifyFileExist(){var self=this.relatedListInstance,aDeferred=jQuery.Deferred(),selectedIds=self.readSelectedIds(!0),excludedIds=self.readExcludedIds(!0),cvId=self.getCurrentCvId(),postData=self.getCompleteParams();return delete postData.mode,delete postData.view,postData.viewname=cvId,postData.selected_ids=selectedIds,postData.excluded_ids=excludedIds,postData.action="RelationAjax",postData.mode="checkFilesIntegrity",AppConnector.request({type:"POST",data:postData}).done(function(responseData){responseData.result.notify&&Vtiger_Helper_Js.showMessage(responseData.result.notify),aDeferred.resolve(responseData.result.success);}),aDeferred.promise()},/**
		 * Method to trigger mass download action
		 * @param massActionUrl
		 * @param type
		 */triggerMassDownload:function triggerMassDownload(massActionUrl,type){var _this=this,relInstance=this.relatedListInstance;relInstance.checkListRecordSelected()?relInstance.noRecordSelectedAlert():this.verifyFileExist().done(function(data){!0===data&&_this.triggerMassAction(massActionUrl.substring(0,massActionUrl.indexOf("&mode=multiple")),type);});},triggerMassQuickCreate:function triggerMassQuickCreate(moduleName,data){var self=this.relatedListInstance;if(!0!==self.checkListRecordSelected()){var listParams=self.getSelectedParams(),progress=$.progressIndicator({blockInfo:{enabled:!0}}),params={callbackFunction:function callbackFunction(){self.loadRelatedList();},noCache:!0,data:$.extend(data,{sourceView:"RelatedListView",sourceModule:listParams.relatedModule,entityState:listParams.entityState,search_params:listParams.search_params,excluded_ids:listParams.excluded_ids,selected_ids:listParams.selected_ids,relationId:listParams.relationId,relatedRecord:listParams.record,relatedModule:listParams.module})};App.Components.QuickCreate.getForm("index.php?module="+moduleName+"&view=MassQuickCreateModal",moduleName,params).done(function(data){progress.progressIndicator({mode:"hide"}),App.Components.QuickCreate.showModal(data,params),app.registerEventForClockPicker();});}else self.noRecordSelectedAlert();},/**
		 * Function to trigger mass send email modal
		 */triggerSendEmail:function triggerSendEmail(){var params=Vtiger_RelatedList_Js.relatedListInstance.getDefaultParams();Vtiger_List_Js.triggerSendEmail($.extend(params,{relatedLoad:!0,module:Vtiger_RelatedList_Js.relatedListInstance.moduleName,sourceModule:app.getModuleName(),sourceRecord:app.getRecordId()}),function(){Vtiger_Detail_Js.reloadRelatedList();});},/**
		 * Function to trigger mass send email modal by row
		 */triggerSendEmailByRow:function triggerSendEmailByRow(row){row instanceof jQuery||(row=$(row));var params=Vtiger_RelatedList_Js.relatedListInstance.getDefaultParams();Vtiger_List_Js.triggerSendEmail($.extend(params,{relatedLoad:!0,module:Vtiger_RelatedList_Js.relatedListInstance.moduleName,sourceModule:app.getModuleName(),sourceRecord:app.getRecordId(),selected_ids:"[\""+$(row).closest(".js-list__row").data("id")+"\"]"}),function(){Vtiger_Detail_Js.reloadRelatedList();},row);}},{selectedRelatedTabElement:!1,parentRecordId:!1,parentModuleName:!1,moduleName:!1,relatedTabsContainer:!1,content:!1,listSearchInstance:!1,detailViewContentHolder:!1,relatedView:!1,frameProgress:!1,noEventsListSearch:!1,listViewContainer:!1,defaultParams:{},setSelectedTabElement:function setSelectedTabElement(tabElement){this.selectedRelatedTabElement=tabElement;},getSelectedTabElement:function getSelectedTabElement(){return this.selectedRelatedTabElement},getParentId:function getParentId(){return this.parentRecordId},getRelatedContainer:function getRelatedContainer(){return this.content},setRelatedContainer:function setRelatedContainer(container){this.content=container,this.relatedView=container.find("input.relatedView").val();},getContentHolder:function getContentHolder(){return !1==this.detailViewContentHolder&&(this.detailViewContentHolder=$("div.details div.contents")),this.detailViewContentHolder},getCurrentPageNum:function getCurrentPageNum(){return $("input[name=\"currentPageNum\"]",this.content).val()},setCurrentPageNumber:function setCurrentPageNumber(pageNumber){$("input[name=\"currentPageNum\"]",this.content).val(pageNumber);},getOrderBy:function getOrderBy(){return $("#orderBy",this.content).val()},getDefaultParams:function getDefaultParams(){var container=this.getRelatedContainer(),params=Object.assign({},this.defaultParams);if(params.page=this.getCurrentPageNum(),params.orderby=this.getOrderBy(),container.find("#relationId").val()&&(params.relationId=container.find("#relationId").val()),container.find(".js-relation-cv-id").val()&&(params.cvId=container.find(".js-relation-cv-id").val()),container.find(".pagination").length&&(params.totalCount=container.find(".pagination").data("totalCount")),container.find(".entityState").length&&(params.entityState=container.find(".entityState").val()),this.listSearchInstance){params.search_params=this.listSearchInstance.getListSearchParams();var searchValue=this.listSearchInstance.getAlphabetSearchValue();"undefined"!=typeof searchValue&&0<searchValue.length&&(params.search_key=this.listSearchInstance.getAlphabetSearchField(),params.search_value=searchValue,params.operator="s"),this.listSearchInstance.parseConditions(params),params.search_params=JSON.stringify(params.search_params);}if("Calendar"==this.moduleName){var switchBtn=container.find(".js-switch--calendar");switchBtn.length&&(params.time=switchBtn.first().prop("checked")?"current":"history");}return params},getCompleteParams:function getCompleteParams(){var container=this.getRelatedContainer(),params={view:"Detail",module:this.parentModuleName,record:this.getParentId(),relatedModule:this.moduleName,relatedView:this.relatedView,mode:"showRelatedList",tab_label:container.find("#tab_label").val()};return $.extend(this.getDefaultParams(),params)},getSelectedParams:function getSelectedParams(){return $.extend(this.getCompleteParams(),{selected_ids:this.readSelectedIds(!0),excluded_ids:this.readExcludedIds(!0),cvid:this.getCurrentCvId()})},parseUrlParams:function parseUrlParams(url){this.defaultParams=url?app.convertUrlToObject(url):{};},loadRelatedList:function loadRelatedList(params){var aDeferred=jQuery.Deferred(),thisInstance=this;if("undefined"==typeof thisInstance.moduleName||0>=thisInstance.moduleName.length){var currentInstance=Vtiger_Detail_Js.getInstance();return currentInstance.loadWidgets(),aDeferred.promise()}var progressInstance=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),completeParams=this.getCompleteParams(),activeTabsReference=thisInstance.relatedTabsContainer.find("li.active").data("reference");return AppConnector.request($.extend(completeParams,params)).done(function(responseData){var currentInstance=Vtiger_Detail_Js.getInstance();currentInstance.loadWidgets(),progressInstance.progressIndicator({mode:"hide"}),"ProductsAndServices"!==activeTabsReference&&(thisInstance.relatedTabsContainer.find("li").removeClass("active"),thisInstance.selectedRelatedTabElement.addClass("active"),thisInstance.content.html(responseData),$(".pageNumbers",thisInstance.content).tooltip(),thisInstance.registerPostLoadEvents(),thisInstance.registerListEvents()),aDeferred.resolve(responseData);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown),app.showNotify({text:app.vtranslate("JS_NOT_ALLOWED_VALUE"),type:"error"}),progressInstance.progressIndicator({mode:"hide"});}),aDeferred.promise()},showSelectRelation:function showSelectRelation(extendParams){var _this2=this,params=$.extend(this.getRecordsListParams(),extendParams);app.showRecordsList(params,function(_modal,instance){instance.setSelectEvent(function(responseData){_this2.addRelations(Object.keys(responseData)).done(function(){app.event.trigger("RelatedListView.AfterSelectRelation",responseData,_this2,instance,params);var detail=Vtiger_Detail_Js.getInstance();_this2.loadRelatedList().done(function(){detail.registerRelatedModulesRecordCount();}),"LBL_RECORD_SUMMARY"===_this2.getSelectedTabElement().data("link-key")&&(detail.loadWidgets(),detail.registerRelatedModulesRecordCount());});});});},getRecordsListParams:function getRecordsListParams(){return {module:this.moduleName,src_module:this.parentModuleName,src_record:this.parentRecordId,multi_select:!0}},addRelations:function addRelations(idList){var params=1<arguments.length&&void 0!==arguments[1]?arguments[1]:{},aDeferred=jQuery.Deferred();return AppConnector.request($.extend({module:this.parentModuleName,action:"RelationAjax",mode:"addRelation",related_module:this.moduleName,src_record:this.parentRecordId,relationId:this.getCompleteParams().relationId,related_record_list:$.isArray(idList)?JSON.stringify(idList):idList},params)).done(function(responseData){aDeferred.resolve(responseData);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown);}),aDeferred.promise()},deleteRelation:function deleteRelation(target){var _this3=this,params={};if(target.data("url"))params=target.data("url");else {var id=target.data("id")?target.data("id"):target.closest("tr").data("id");params={module:this.parentModuleName,action:"RelationAjax",mode:"deleteRelation",related_module:this.moduleName,src_record:this.parentRecordId,relationId:this.getCompleteParams().relationId,related_record_list:JSON.stringify([id])};}var progressInstance=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request(params).done(function(response){if(progressInstance.progressIndicator({mode:"hide"}),response.result){var widget=target.closest(".widgetContentBlock"),detail=Vtiger_Detail_Js.getInstance();if(widget.length){detail.loadWidget(widget);var updatesWidget=_this3.getContentHolder().find("[data-type=\"Updates\"]");0<updatesWidget.length&&detail.loadWidget(updatesWidget);}else _this3.loadRelatedList();detail.registerRelatedModulesRecordCount();}else app.showNotify({text:app.vtranslate("JS_CANNOT_REMOVE_RELATION"),type:"error"});}).fail(function(){progressInstance.progressIndicator({mode:"hide"}),app.showNotify({text:app.vtranslate("JS_CANNOT_REMOVE_RELATION"),type:"error"});});},/**
		 * Function to handle next page navigation
		 */nextPageHandler:function nextPageHandler(){var aDeferred=jQuery.Deferred(),thisInstance=this,pageLimit=jQuery("#pageLimit",this.content).val(),noOfEntries=jQuery("#noOfEntries",this.content).val();if(noOfEntries==pageLimit){var pageNumber=this.getCurrentPageNum(),nextPage=parseInt(pageNumber)+1;this.loadRelatedList({page:nextPage}).done(function(data){thisInstance.setCurrentPageNumber(nextPage),aDeferred.resolve(data);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown);});}return aDeferred.promise()},/**
		 * Function to handle next page navigation
		 */previousPageHandler:function previousPageHandler(){var thisInstance=this,aDeferred=jQuery.Deferred(),pageNumber=this.getCurrentPageNum();if(1<pageNumber){var previousPage=parseInt(pageNumber)-1;this.loadRelatedList({page:previousPage}).done(function(data){thisInstance.setCurrentPageNumber(previousPage),aDeferred.resolve(data);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown);});}return aDeferred.promise()},/**
		 * Function to handle select page jump in related list
		 */selectPageHandler:function selectPageHandler(pageNumber){var thisInstance=this,aDeferred=jQuery.Deferred();return this.loadRelatedList({page:pageNumber}).done(function(data){thisInstance.setCurrentPageNumber(pageNumber),aDeferred.resolve(data);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown);}),aDeferred.promise()},/**
		 * Function to handle page jump in related list
		 */pageJumpHandler:function pageJumpHandler(e){var aDeferred=jQuery.Deferred(),thisInstance=this;if(13==e.which){var element=jQuery(e.currentTarget),response=Vtiger_WholeNumberGreaterThanZero_Validator_Js.invokeValidation(element);if("undefined"!=typeof response)element.validationEngine("showPrompt",response,"","topLeft",!0),e.preventDefault();else {element.validationEngine("hideAll");var jumpToPage=parseInt(element.val()),totalPages=parseInt(jQuery("#totalPageCount",thisInstance.content).text());if(jumpToPage>totalPages){var error=app.vtranslate("JS_PAGE_NOT_EXIST");element.validationEngine("showPrompt",error,"","topLeft",!0);}var invalidFields=element.parent().find(".formError");if(1>invalidFields.length){var currentPage=jQuery("input[name=\"currentPageNum\"]",thisInstance.content).val();if(jumpToPage==currentPage){var message=app.vtranslate("JS_YOU_ARE_IN_PAGE_NUMBER")+" "+jumpToPage;return Vtiger_Helper_Js.showMessage({text:message,type:"info"}),e.preventDefault(),!1}this.loadRelatedList({page:jumpToPage}).done(function(data){thisInstance.setCurrentPageNumber(jumpToPage),aDeferred.resolve(data);}).fail(function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown);});}else e.preventDefault();}}return aDeferred.promise()},/**
		 * Function to add related record for the module
		 */addRelatedRecord:function addRelatedRecord(element,callback){var aDeferred=jQuery.Deferred(),referenceModuleName=this.moduleName,parentId=this.getParentId(),parentModule=this.parentModuleName,quickCreateParams={},relatedParams={},relatedField=element.data("name"),fullFormUrl=element.data("url");relatedField&&(relatedParams[relatedField]=parentId);var eliminatedKeys=new Array("view","module","mode","action");//If url contains params then seperate them and make them as relatedParams
if("undefined"!=typeof fullFormUrl&&-1!==fullFormUrl.indexOf("?"))for(var urlSplit=fullFormUrl.split("?"),queryString=urlSplit[1],queryParameters=queryString.split("&"),index=0;index<queryParameters.length;index++){var queryParam=queryParameters[index],queryParamComponents=queryParam.split("=");"-1"==jQuery.inArray(queryParamComponents[0],eliminatedKeys)&&(relatedParams[queryParamComponents[0]]=queryParamComponents[1]);}return quickCreateParams.data=relatedParams,quickCreateParams.callbackFunction=function(data){aDeferred.resolve(data);},quickCreateParams.callbackPostShown=function preQuickCreateSave(data){var index,queryParam,queryParamComponents,queryParameters=[];//To handle switch to task tab when click on add task from related list of activities
//As this is leading to events tab intially even clicked on add task
if("undefined"!=typeof fullFormUrl&&-1!==fullFormUrl.indexOf("?")){var urlSplit=fullFormUrl.split("?"),queryString=urlSplit[1];for(queryParameters=queryString.split("&"),index=0;index<queryParameters.length;index++)queryParam=queryParameters[index],queryParamComponents=queryParam.split("="),"mode"==queryParamComponents[0]&&"Calendar"==queryParamComponents[1]&&data.find("a[data-tab-name=\"Task\"]").trigger("click");}if(jQuery("<input type=\"hidden\" name=\"sourceModule\" value=\""+parentModule+"\" />").appendTo(data),jQuery("<input type=\"hidden\" name=\"sourceRecord\" value=\""+parentId+"\" />").appendTo(data),jQuery("<input type=\"hidden\" name=\"relationOperation\" value=\"true\" />").appendTo(data),"undefined"!=typeof relatedField){var field=data.find("[name=\""+relatedField+"\"]");//If their is no element with the relatedField name,we are adding hidden element with
//name as relatedField name,for saving of record with relation to parent record
0==field.length&&jQuery("<input type=\"hidden\" name=\""+relatedField+"\" value=\""+parentId+"\" />").appendTo(data);}for(index=0;index<queryParameters.length;index++)queryParam=queryParameters[index],queryParamComponents=queryParam.split("="),"-1"==jQuery.inArray(queryParamComponents[0],eliminatedKeys)&&0==data.find("[name=\""+queryParamComponents[0]+"\"]").length&&jQuery("<input type=\"hidden\" name=\""+queryParamComponents[0]+"\" value=\""+queryParamComponents[1]+"\" />").appendTo(data);"undefined"!=typeof callback&&callback();},quickCreateParams.noCache=!0,App.Components.QuickCreate.createRecord(referenceModuleName,quickCreateParams),aDeferred.promise()},getRelatedPageCount:function getRelatedPageCount(){var aDeferred=jQuery.Deferred(),element=this.content.find("#totalPageCount"),totalCountElem=this.content.find("#totalCount"),totalPageNumber=element.text();return ""==totalPageNumber?(element.progressIndicator({}),AppConnector.request({module:this.parentModuleName,action:"RelationAjax",mode:"getRelatedListPageCount",record:this.getParentId(),relationId:this.getCompleteParams().relationId,relatedModule:this.moduleName}).done(function(data){var pageCount=data.result.page,numberOfRecords=data.result.numberOfRecords;totalCountElem.val(numberOfRecords),element.text(pageCount),element.progressIndicator({mode:"hide"}),aDeferred.resolve();}).fail(function(error,err){aDeferred.reject(!1);})):aDeferred.resolve(),aDeferred.promise()},favoritesRelation:function favoritesRelation(relcrmId,state){var aDeferred=jQuery.Deferred();return relcrmId?AppConnector.request({module:this.parentModuleName,action:"RelationAjax",mode:"updateFavoriteForRecord",record:this.getParentId(),relcrmid:relcrmId,relatedModule:this.moduleName,relationId:this.getCompleteParams().relationId,actionMode:state?"delete":"add"}).done(function(data){data.result&&aDeferred.resolve(!0);}).fail(function(error,err){aDeferred.reject(!1);}):aDeferred.reject(!1),aDeferred.promise()},updatePreview:function updatePreview(url){var frame=this.content.find(".listPreviewframe");this.frameProgress=$.progressIndicator({position:"html",message:app.vtranslate("JS_FRAME_IN_PROGRESS"),blockInfo:{enabled:!0}});var defaultView="";app.getMainParams("defaultDetailViewName")&&(defaultView=defaultView+"&mode=showDetailViewByMode&requestMode="+app.getMainParams("defaultDetailViewName")),frame.attr("src",url.replace("view=Detail","view=DetailPreview")+defaultView);},registerUnreviewedCountEvent:function registerUnreviewedCountEvent(){var ids=[],relatedContent=this.content,isUnreviewedActive=relatedContent.find(".unreviewed").length;relatedContent.find("tr.listViewEntries").each(function(){var id=jQuery(this).data("id");id&&ids.push(id);});1>isUnreviewedActive||AppConnector.request({action:"ChangesReviewedOn",mode:"getUnreviewed",module:"ModTracker",sourceModule:this.moduleName,recordsId:ids}).done(function(appData){var data=appData.result;$.each(data,function(id,value){0<value.a&&relatedContent.find("tr[data-id=\""+id+"\"] .unreviewed .badge.all").text(value.a).parent().removeClass("d-none"),0<value.m&&relatedContent.find("tr[data-id=\""+id+"\"] .unreviewed .badge.mail").text(value.m).parent().removeClass("d-none");});});},registerChangeEntityStateEvent:function registerChangeEntityStateEvent(){var thisInstance=this,relatedContent=this.content;relatedContent.on("click",".dropdownEntityState a",function(e){var element=$(this);relatedContent.find(".entityState").val(element.data("value")),relatedContent.find(".pagination").data("totalCount",0),relatedContent.find(".dropdownEntityState button").find("span").attr("class",element.find("span").attr("class")),thisInstance.loadRelatedList({page:1});});},registerRowsEvent:function registerRowsEvent(){var self=this;if("List"===this.relatedView||"Detail"===this.relatedView){var lastEvent=!1;this.content.find(".listViewEntries").on("click",function(e){if(!$(e.target).hasClass("js-no-link")&&!$(e.target).closest("div").hasClass("actions")&&!($(e.target).is("button")||$(e.target).parent().is("button")||$(e.target).is("a"))&&!$(e.target).closest("a").hasClass("noLinkBtn")&&!$(e.target).is("a")&&!$(e.target).is("input")){var element=$(e.currentTarget);if(!$(e.target,element).is("td:first-child")&&!$.contains(element.find("td:last-child").get(0),e.target)&&!$.contains(element.find("td:first-child").get(0),e.target)){var recordUrl=element.data("recordurl");recordUrl&&(lastEvent?(lastEvent=e.timeStamp,element.find(".js-quick-edit-modal").length?element.find(".js-quick-edit-modal").trigger("click"):element.find(".js-full-edit").length&&element.find(".js-full-edit").trigger("click")):(lastEvent=e.timeStamp,setTimeout(function(){lastEvent===e.timeStamp?"DetailPreview"===app.getViewName()?top.document.location.href=recordUrl:document.location.href=recordUrl:lastEvent=!1;},300)));}}}),this.content.find(".js-toggle-hidden-row").on("click",function(e){var target=$(this),row=target.closest("tr"),inventoryRow=row.next(".js-hidden-row");if(inventoryRow.length){var block=inventoryRow.find(".js-hidden-row__block[data-element=\""+target.data("element")+"\"]");(block.is(":visible")||!inventoryRow.is(":visible"))&&inventoryRow.toggleClass("d-none"),inventoryRow.find(".js-hidden-row__block").addClass("d-none"),block.removeClass("d-none"),block.is(":visible")&&self.registerWidgets(block);}});}else "ListPreview"===this.relatedView&&this.content.find(".listViewEntries").on("click",function(e){var target=$(e.target);if(!target.closest("div").hasClass("actions")&&!(target.is("button")||target.parent().is("button"))&&!target.closest("a").hasClass("noLinkBtn")&&!$(e.target,$(e.currentTarget)).is("td:first-child")&&!target.is("input[type=\"checkbox\"]")&&!$.contains($(e.currentTarget).find("td:last-child").get(0),target[0])&&!$.contains($(e.currentTarget).find("td:first-child").get(0),target[0])){var recordUrl=$(this).data("recordurl");self.content.find(".listViewEntriesTable .listViewEntries").removeClass("active"),$(this).addClass("active"),self.updatePreview(recordUrl);}});var widgetsContainer=this.content.find(".js-hidden-row .js-hidden-row__block[data-element=\"widgets\"]");widgetsContainer.length&&self.registerWidgets(widgetsContainer);},registerWidgets:function registerWidgets(content){var widgetList=$("[class^=\"widgetContainer_\"]",content),detailInstance=Vtiger_Detail_Js.getInstance();widgetList.each(function(index,widget){widget=$(widget),widget.is(":visible")&&detailInstance.loadWidget(widget);});},registerSummationEvent:function registerSummationEvent(){var thisInstance=this;this.content.on("click",".listViewSummation button",function(){var button=$(this),calculateValue=button.closest("td").find(".calculateValue"),params=thisInstance.getCompleteParams();params.action="RelationAjax",params.mode="calculate",params.fieldName=button.data("field"),params.calculateType=button.data("operator"),delete params.view;var progress=$.progressIndicator({message:app.vtranslate("JS_CALCULATING_IN_PROGRESS"),position:"html",blockInfo:{enabled:!0}});app.hidePopover(button),AppConnector.request(params).done(function(response){response.success?calculateValue.html(response.result):calculateValue.html(""),progress.progressIndicator({mode:"hide"});}),progress.progressIndicator({mode:"hide"});});},registerPreviewEvent:function registerPreviewEvent(){var thisInstance=this,contentHeight=this.content.find(".js-detail-preview,.js-list-preview");contentHeight.height(app.getScreenHeight()-(this.content.offset().top+$(".js-footer").height())),this.content.find(".listPreviewframe").on("load",function(){thisInstance.frameProgress&&thisInstance.frameProgress.progressIndicator({mode:"hide"}),contentHeight.height($(this).contents().find(".bodyContents").height()+2);}),this.content.find(".listViewEntriesTable .listViewEntries").first().trigger("click");},registerPaginationEvents:function registerPaginationEvents(){var thisInstance=this,relatedContent=this.content;this.content.on("click","#relatedViewNextPageButton",function(e){$(this).hasClass("disabled")||thisInstance.nextPageHandler();}),this.content.on("click","#relatedViewPreviousPageButton",function(){thisInstance.previousPageHandler();}),this.content.on("click","#relatedListPageJump",function(e){thisInstance.getRelatedPageCount();}),this.content.on("click","#relatedListPageJumpDropDown > li",function(e){e.stopImmediatePropagation();}).on("keypress","#pageToJump",function(e){thisInstance.pageJumpHandler(e);}),this.content.on("click",".pageNumber",function(){return !$(this).hasClass("disabled")&&void thisInstance.selectPageHandler($(this).data("id"))}),this.content.on("click","#totalCountBtn",function(){app.hidePopover($(this));var params={module:thisInstance.parentModuleName,view:"Pagination",mode:"getRelationPagination",record:thisInstance.getParentId(),relatedModule:thisInstance.moduleName,noOfEntries:$("#noOfEntries",relatedContent).val(),page:relatedContent.find("[name=\"currentPageNum\"]").val()};relatedContent.find("#relationId").val()&&(params.relationId=relatedContent.find("#relationId").val()),relatedContent.find(".entityState").length&&(params.entityState=relatedContent.find(".entityState").val()),AppConnector.request(params).done(function(response){relatedContent.find(".paginationDiv").html(response);});});},registerListEvents:function registerListEvents(){var thisInstance=this;this.content.find("a.favorites").on("click",function(){var progressInstance=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),element=$(this),row=element.closest("tr");thisInstance.favoritesRelation(row.data("id"),element.data("state")).done(function(response){if(response){var state=element.data("state")?0:1;element.data("state",state),state?(element.find(".far").addClass("d-none"),element.find(".fas").removeClass("d-none")):(element.find(".fas").addClass("d-none"),element.find(".far").removeClass("d-none")),progressInstance.progressIndicator({mode:"hide"});var text=app.vtranslate("JS_REMOVED_FROM_FAVORITES");state&&(text=app.vtranslate("JS_ADDED_TO_FAVORITES")),app.showNotify({text:text,type:"success"});}});}),this.content.find("[name=\"addButton\"]").on("click",function(){var element=$(this);return !0===element.hasClass("quickCreateSupported")?void thisInstance.addRelatedRecord(element):void app.openUrl(element.data("url"))}),this.content.find(".relatedHeader button.selectRelation").on("click",function(){var restrictionsField=$(this).data("rf"),params={relationId:thisInstance.getCompleteParams().relationId};restrictionsField&&0<Object.keys(restrictionsField).length&&(params={search_key:restrictionsField.key,search_value:restrictionsField.name,relationId:thisInstance.getCompleteParams().relationId}),thisInstance.showSelectRelation(params);}),this.content.find("button.relationDelete").on("click",function(e){e.stopImmediatePropagation();var target=$(e.currentTarget),params={icon:!1,confirmedCallback:function confirmedCallback(){thisInstance.deleteRelation(target);}};target.data("confirm")?(params.text=target.data("confirm"),params.title=target.html()+" "+target.data("content")):target.data("content")?params.text=target.data("content"):params.text=app.vtranslate("JS_DELETE_CONFIRMATION"),app.showConfirmModal(params);}),this.content.find(".js-switch--calendar,select.js-relation-cv-id").on("change",function(){thisInstance.listSearchInstance.reloadList({search_params:[],search_key:"",search_value:"",operator:"",lockedEmptyFields:[],page:1,totalCount:0});});},registerPostLoadEvents:function registerPostLoadEvents(){var thisInstance=this;if(this.registerRowsEvent(),this.registerListScroll(),"ListPreview"===this.relatedView&&(this.registerPreviewEvent(),!this.content.find(".gutter").length)){if(!this.content.find(".js-list-preview").length)return;this.setDomParams(this.content),this.toggleSplit(this.content),this.registerListPreviewEvents();}this.listSearchInstance=!!this.content.find(".listViewSearchTd [data-trigger=\"listSearch\"]").length&&YetiForce_ListSearch_Js.getInstance(this.content,!1,this),app.event.trigger("RelatedList.AfterLoad",thisInstance);},getListColumnWidth:function getListColumnWidth(){var width=300,column=this.container.find(".listViewEntriesDiv .listViewHeaders th:eq(1)");return column.length&&(width=column.offset().left+column.width()),width},setDomParams:function setDomParams(container){this.container=container,this.listColumnWidth=this.getListColumnWidth(),this.windowW=$(window).width(),this.mainBody=container.closest(".mainBody"),this.windowMinWidth=100*(15/this.windowW),this.windowMaxWidth=100-this.minWidth,this.sideBlocks=container.find(".js-side-block"),this.sideBlockLeft=this.sideBlocks.first(),this.sideBlockRight=this.sideBlocks.last(),this.list=container.find(".js-list-preview"),this.preview=container.find(".js-detail-preview"),this.rotatedText=container.find(".u-rotate-90"),this.footerH=$(".js-footer").outerHeight(),this.headerH=$(".js-header").outerHeight();},getDefaultSplitSizes:function getDefaultSplitSizes(){var thWidth=100*(this.listColumnWidth/this.windowW);return [thWidth,100-thWidth]},getSplitSizes:function getSplitSizes(){var cachedParams=app.moduleCacheGet("userRelatedSplitSet");return void 0===cachedParams?this.getDefaultSplitSizes():cachedParams},registerListPreviewEvents:function registerListPreviewEvents(){var _this4=this;app.showNewScrollbarTopBottom(this.content.find(".js-list-preview--scroll")),app.showNewScrollbarLeft(this.list),this.list.on("click",".listViewEntries",function(){if(10>_this4.split.getSizes()[1]){var defaultGutterPosition=_this4.getDefaultSplitSizes();_this4.split.setSizes(defaultGutterPosition),_this4.preview.show(),_this4.sideBlockRight.removeClass("d-block"),app.moduleCacheSet("userRelatedSplitSet",defaultGutterPosition);}}),this.list.parents(".blockContent").length||this.registerScrollEvent();},registerScrollEvent:function registerScrollEvent(){var _this5=this;this.gutter.addClass("js-fixed-scroll");var scrollContainer=App.Components.Scrollbar.page.element,listOffsetTop=this.list.offset().top-this.headerH,initialH=this.sideBlocks.height(),mainViewPortHeightCss={height:this.mainBody.height()},mainViewPortWidthCss={width:this.mainBody.height()},fixedElements=this.mainBody.find(".js-fixed-scroll");if(!this.mainBody.length){this.mainBody=$(top.document).find(".mainBody"),this.headerH=$(top.document).find(".js-header").outerHeight(),scrollContainer=top.window.App.Components.Scrollbar.page.element;var iframe=$(top.document).find(".js-detail-preview");listOffsetTop=this.list.offset().top+iframe.offset().top-this.headerH+1,mainViewPortHeightCss={height:this.mainBody.height()},mainViewPortWidthCss={width:this.mainBody.height()};}var onScroll=function onScroll(){scrollContainer.scrollTop()>=listOffsetTop?(fixedElements.css({top:scrollContainer.scrollTop()-listOffsetTop}),_this5.sideBlocks.css({top:scrollContainer.scrollTop()-listOffsetTop+56}),fixedElements.css(mainViewPortHeightCss),_this5.rotatedText.css(mainViewPortHeightCss),_this5.rotatedText.css(mainViewPortWidthCss)):(fixedElements.css({top:"initial"}),fixedElements.css({height:initialH+scrollContainer.scrollTop()}),_this5.rotatedText.css({width:initialH+scrollContainer.scrollTop(),height:initialH+scrollContainer.scrollTop()}));};scrollContainer.on("scroll",onScroll);},/**
		 * Registers split's events.
		 * @param {jQuery} container - current container for reference.
		 * @param {Split} split - a split object.
		 */registerSplitEvents:function registerSplitEvents(container,split){var _this6=this,rightSplitMaxWidth=100*(400/this.windowW),minWindowWidth=100*(23/this.windowW),maxWindowWidth=100-minWindowWidth,listPreview=container.find(".js-detail-preview");this.gutter.on("dblclick",function(){var gutterRelatedMidPosition=app.moduleCacheGet("gutterRelatedMidPosition");isNaN(_this6.split.getSizes()[0])&&_this6.split.setSizes(gutterRelatedMidPosition),7>split.getSizes()[0]?(_this6.gutter.removeClass("js-gutter-corr-left"),_this6.sideBlockLeft.removeClass("d-block"),_this6.list.removeClass("u-hide-underneath"),11<gutterRelatedMidPosition[0]?split.setSizes(gutterRelatedMidPosition):split.setSizes(_this6.getDefaultSplitSizes())):20>split.getSizes()[1]?(gutterRelatedMidPosition[1]>rightSplitMaxWidth+1?split.setSizes(gutterRelatedMidPosition):split.setSizes(_this6.getDefaultSplitSizes()),_this6.gutter.removeClass("js-gutter-corr-right"),_this6.sideBlockRight.removeClass("d-block"),listPreview.show()):7<split.getSizes()[0]&&50>split.getSizes()[0]?(split.setSizes([minWindowWidth,maxWindowWidth]),_this6.gutter.addClass("js-gutter-corr-left"),_this6.sideBlockLeft.addClass("d-block"),_this6.list.addClass("u-hide-underneath")):10<split.getSizes()[1]&&50>split.getSizes()[1]&&(split.setSizes([maxWindowWidth,minWindowWidth]),_this6.gutter.addClass("js-gutter-corr-right"),_this6.sideBlockRight.addClass("d-block"),listPreview.hide()),app.moduleCacheSet("userRelatedSplitSet",split.getSizes());}),this.sideBlockLeft.on("click",function(){var gutterRelatedMidPosition=app.moduleCacheGet("gutterRelatedMidPosition");11<gutterRelatedMidPosition[0]?split.setSizes(gutterRelatedMidPosition):split.setSizes(_this6.getDefaultSplitSizes()),_this6.gutter.removeClass("js-gutter-corr-left"),_this6.sideBlockLeft.removeClass("d-block"),_this6.list.removeClass("u-hide-underneath"),app.moduleCacheSet("userRelatedSplitSet",split.getSizes());}),this.sideBlockRight.on("click",function(){var gutterRelatedMidPosition=app.moduleCacheGet("gutterRelatedMidPosition");gutterRelatedMidPosition[1]>rightSplitMaxWidth+1?split.setSizes(gutterRelatedMidPosition):split.setSizes(_this6.getDefaultSplitSizes()),_this6.gutter.removeClass("js-gutter-corr-right"),_this6.sideBlockRight.removeClass("d-block"),listPreview.show(),app.moduleCacheSet("userRelatedSplitSet",split.getSizes());});},registerSplit:function registerSplit(container){var _this7=this,rightSplitMaxWidth=100*(400/this.windowW),splitSizes=this.getSplitSizes();app.moduleCacheSet("gutterRelatedMidPosition",splitSizes);var split=Split([this.list[0],this.preview[0]],{sizes:splitSizes,minSize:10,gutterSize:24,snapOffset:100,onDrag:function onDrag(){split.getSizes()[1]<rightSplitMaxWidth&&split.collapse(1),7>split.getSizes()[0]?(_this7.sideBlockLeft.addClass("d-block"),_this7.list.addClass("u-hide-underneath")):(_this7.gutter.removeClass("js-gutter-corr-left"),_this7.sideBlockLeft.removeClass("d-block"),_this7.list.removeClass("u-hide-underneath")),10>split.getSizes()[1]?(_this7.sideBlockRight.addClass("d-block"),_this7.preview.hide(),_this7.list.width(_this7.list.width()-10)):(_this7.gutter.removeClass("js-gutter-corr-right"),_this7.sideBlockRight.removeClass("d-block"),_this7.preview.show()),10<split.getSizes()[0]&&split.getSizes()[1]>rightSplitMaxWidth&&app.moduleCacheSet("gutterRelatedMidPosition",split.getSizes()),app.moduleCacheSet("userRelatedSplitSet",split.getSizes());}});10>splitSizes[0]?(this.gutter.addClass("js-gutter-corr-left"),this.sideBlockLeft.addClass("d-block"),this.list.addClass("u-hide-underneath")):splitSizes[1]<rightSplitMaxWidth&&(this.gutter.addClass("js-gutter-corr-right"),this.sideBlockRight.addClass("d-block"),this.preview.hide()),this.gutter=container.find(".gutter");var mainWindowHeightCss={height:$(window).height()-this.list.offset().top-this.footerH};if(!container.closest(".mainBody").length){var mainBody=$(top.document).find(".mainBody").height(),iframe=$(top.document).find(".js-detail-preview");mainWindowHeightCss={height:mainBody-this.list.offset().top-iframe.offset().top+50};}return this.list.parents(".blockContent").length||(this.gutter.css(mainWindowHeightCss),this.list.css(mainWindowHeightCss),this.sideBlocks.css(mainWindowHeightCss),this.rotatedText.css({width:this.sideBlockLeft.height(),height:this.sideBlockLeft.height()})),this.registerSplitEvents(container,split),split},toggleSplit:function toggleSplit(container){var _this8=this,commactHeight=container.closest(".commonActionsContainer").height(),splitsArray=[];this.split=this.registerSplit(container),splitsArray.push(this.split),$(window).on("resize",function(){if(993>_this8.windowW)container.find(".gutter").length&&(splitsArray[splitsArray.length-1].destroy(),_this8.sideBlockRight.removeClass("d-block"),_this8.sideBlockLeft.removeClass("d-block"));else {if(1!==container.find(".gutter").length){_this8.split=_this8.registerSplit(container);var gutter=container.find(".gutter");_this8.mainBody.scrollTop()>=_this8.list.offset().top+commactHeight&&(gutter.addClass("gutterOnScroll"),gutter.css("left",_this8.preview.offset().left-8),gutter.on("mousedown",function(){$(this).on("mousemove",function(e){$(this).css("left",this.preview.offset().left-8);});})),splitsArray.push(_this8.split);}var currentSplit=splitsArray[splitsArray.length-1],minWidth=100*(15/_this8.windowW),maxWidth=100-minWidth;if("undefined"==typeof currentSplit)return;currentSplit.getSizes()[0]<minWidth+5?currentSplit.setSizes([minWidth,maxWidth]):currentSplit.getSizes()[1]<minWidth+5&&currentSplit.setSizes([maxWidth,minWidth]);}});},registerListScroll:function registerListScroll(){var container=$(".listViewEntriesDiv");"ListPreview"!==this.relatedView&&Quasar.plugins.Platform.is.desktop&&container.each(function(index,element){container.closest(".js-detail-widget-content").length?(element=container.closest(".js-detail-widget-content"),element.each(function(i,el){App.Components.Scrollbar.xy($(el));})):App.Components.Scrollbar.xy($(element));});},getRecordsCount:function getRecordsCount(){var aDeferred=$.Deferred(),recordCountVal=$("#recordsCount").val();if(0<=parseInt(recordCountVal))aDeferred.resolve(recordCountVal);else {var params=this.getCompleteParams();delete params.view,params.action="DetailAjax",params.mode="getRecordsCount",AppConnector.request(params).done(function(data){$("#recordsCount").val(data.result.count),aDeferred.resolve(data.result.count);});}return aDeferred.promise()},noRecordSelectedAlert:function noRecordSelectedAlert(){var text=0<arguments.length&&arguments[0]!==void 0?arguments[0]:"JS_PLEASE_SELECT_ONE_RECORD";app.showNotify({text:app.vtranslate(text),type:"error"});},getCurrentCvId:function getCurrentCvId(){return $("#customFilter").find("option:selected").data("id")},checkListRecordSelected:function checkListRecordSelected(){var minNumberOfRecords=0<arguments.length&&arguments[0]!==void 0?arguments[0]:1,selectedIds=this.readSelectedIds();return "object"===_typeof(selectedIds)&&selectedIds.length<minNumberOfRecords},readSelectedIds:function readSelectedIds(decode){var selectedIdsDataAttr=this.getCurrentCvId()+"selectedIds",selectedIdsElementDataAttributes=$("#selectedIds").data(),selectedIds=[];if("undefined"===selectedIdsElementDataAttributes[selectedIdsDataAttr])this.writeSelectedIds(selectedIds);else {var _selectedIdsElementDa;selectedIds=null!==(_selectedIdsElementDa=selectedIdsElementDataAttributes[selectedIdsDataAttr])&&void 0!==_selectedIdsElementDa?_selectedIdsElementDa:[];}return !0==decode&&"object"==_typeof(selectedIds)?JSON.stringify(selectedIds):selectedIds},writeSelectedIds:function writeSelectedIds(selectedIds){Array.isArray(selectedIds)||(selectedIds=[selectedIds]),$("#selectedIds").data(this.getCurrentCvId()+"selectedIds",selectedIds);},readExcludedIds:function readExcludedIds(decode){var excludedIdsDataAttr=this.getCurrentCvId()+"Excludedids",excludedIdsElementDataAttributes=$("#excludedIds").data(),excludedIds=[];if("undefined"===excludedIdsElementDataAttributes[excludedIdsDataAttr])this.writeExcludedIds(excludedIds);else {var _excludedIdsElementDa;excludedIds=null!==(_excludedIdsElementDa=excludedIdsElementDataAttributes[excludedIdsDataAttr])&&void 0!==_excludedIdsElementDa?_excludedIdsElementDa:[];}return !0==decode&&"object"==_typeof(excludedIds)?JSON.stringify(excludedIds):excludedIds},writeExcludedIds:function writeExcludedIds(excludedIds){$("#excludedIds").data(this.getCurrentCvId()+"Excludedids",excludedIds);},checkSelectAll:function checkSelectAll(){var state=!0;return $(".relatedListViewEntriesCheckBox").each(function(index,element){state=!!$(element).is(":checked");}),$("#relatedListViewEntriesMainCheckBox").prop("checked",state),state},registerCheckBoxClickEvent:function registerCheckBoxClickEvent(){var self=this;this.getRelatedContainer().on("click",".relatedListViewEntriesCheckBox",function(e){var selectedIds=self.readSelectedIds(),excludedIds=self.readExcludedIds(),elem=$(e.currentTarget);elem.is(":checked")?(elem.closest("tr").addClass("highlightBackgroundColor"),"all"==selectedIds?excludedIds.splice($.inArray(elem.val(),excludedIds),1):-1==$.inArray(elem.val(),selectedIds)&&selectedIds.push(elem.val())):(elem.closest("tr").removeClass("highlightBackgroundColor"),"all"==selectedIds?(excludedIds.push(elem.val()),selectedIds="all"):selectedIds.splice($.inArray(elem.val(),selectedIds),1)),self.checkSelectAll(),self.writeSelectedIds(selectedIds),self.writeExcludedIds(excludedIds);});},registerMainCheckBoxClickEvent:function registerMainCheckBoxClickEvent(){var self=this;this.getRelatedContainer().on("click","#relatedListViewEntriesMainCheckBox",function(){var selectedIds=self.readSelectedIds(),excludedIds=self.readExcludedIds();if($("#relatedListViewEntriesMainCheckBox").is(":checked")){var progress=$.progressIndicator({blockInfo:{enabled:!0}}),recordCountObj=self.getRecordsCount();recordCountObj.done(function(data){progress.progressIndicator({mode:"hide"}),$("#totalRecordsCount").text(data),"none"==$("#deSelectAllMsgDiv").css("display")&&$("#selectAllMsgDiv").show();}).fail(function(){progress.progressIndicator({mode:"hide"});}),$(".relatedListViewEntriesCheckBox").each(function(index,element){$(this).prop("checked",!0).closest("tr").addClass("highlightBackgroundColor"),"all"==selectedIds&&-1!=$.inArray($(element).val(),excludedIds)?excludedIds.splice($.inArray($(element).val(),excludedIds),1):-1==$.inArray($(element).val(),selectedIds)&&selectedIds.push($(element).val());});}else $("#selectAllMsgDiv").hide(),$(".relatedListViewEntriesCheckBox").each(function(index,element){$(this).prop("checked",!1).closest("tr").removeClass("highlightBackgroundColor"),"all"==selectedIds?(excludedIds.push($(element).val()),selectedIds="all"):selectedIds.splice($.inArray($(element).val(),selectedIds),1);});self.writeSelectedIds(selectedIds),self.writeExcludedIds(excludedIds);});},registerSelectAllClickEvent:function registerSelectAllClickEvent(){var self=this;self.getRelatedContainer().on("click","#selectAllMsg",function(){$("#selectAllMsgDiv").hide(),$("#deSelectAllMsgDiv").show(),$("#relatedListViewEntriesMainCheckBox").prop("checked",!0),$(".relatedListViewEntriesCheckBox").each(function(index,element){$(this).prop("checked",!0).closest("tr").addClass("highlightBackgroundColor");}),self.writeSelectedIds("all");});},registerDeselectAllClickEvent:function registerDeselectAllClickEvent(){var self=this;self.getRelatedContainer().on("click","#deSelectAllMsg",function(){$("#deSelectAllMsgDiv").hide(),$("#relatedListViewEntriesMainCheckBox").prop("checked",!1),$(".relatedListViewEntriesCheckBox").each(function(index,element){$(this).prop("checked",!1).closest("tr").removeClass("highlightBackgroundColor");}),self.writeSelectedIds([]),self.writeExcludedIds([]);});},/**
		 * Register change related view.
		 */registerChangeViewEvent:function registerChangeViewEvent(){var self=this;self.getRelatedContainer().on("click",".js-change-related-view",function(){self.relatedView=this.dataset.view,self.loadRelatedList();});},/**
		 * Register mass records events.
		 */registerMassRecordsEvents:function registerMassRecordsEvents(){var self=this;self.getRelatedContainer().on("click",".js-mass-record-event",function(){var target=$(this);if(!(!0!==self.checkListRecordSelected()))self.noRecordSelectedAlert();else if("modal"===target.data("type")){var params=self.getSelectedParams();target.data("url").replace(/[?&]+([^=&]+)=([^&]*)/gi,function(_m,key,value){params[key]=value;}),AppConnector.request({type:"POST",url:target.data("url"),data:params}).done(function(modal){app.showModalWindow(modal);});}else {var _params={icon:!1,confirmedCallback:function confirmedCallback(){var progressIndicatorElement=$.progressIndicator(),dataParams=self.getSearchParams();delete dataParams.view,AppConnector.request({type:"POST",url:target.data("url"),data:dataParams}).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),data&&data.result&&data.result.notify&&Vtiger_Helper_Js.showMessage(data.result.notify),self.getListViewRecords();}).fail(function(error,err){progressIndicatorElement.progressIndicator({mode:"hide"});});}};target.data("confirm")?(_params.text=target.data("confirm"),_params.title=target.html()):_params.text=target.html(),app.showConfirmModal(_params);}});},/**
		 * Register related events
		 */registerRelatedEvents:function registerRelatedEvents(){var _this9=this;this.registerUnreviewedCountEvent(),this.registerChangeEntityStateEvent(),this.registerPaginationEvents(),this.registerListEvents(),this.registerPostLoadEvents(),this.registerSummationEvent(),this.registerCheckBoxClickEvent(),this.registerMainCheckBoxClickEvent(),this.registerSelectAllClickEvent(),this.registerDeselectAllClickEvent(),this.registerChangeViewEvent(),this.registerMassRecordsEvents(),YetiForce_ListSearch_Js.registerSearch(this.content,function(data){_this9.loadRelatedList(data);});}});
//# sourceMappingURL=RelatedList.min.js.map
