'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";function _typeof(o){"@babel/helpers - typeof";return _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(o){return typeof o}:function(o){return o&&"function"==typeof Symbol&&o.constructor===Symbol&&o!==Symbol.prototype?"symbol":typeof o},_typeof(o)}function ownKeys(e,r){var t=Object.keys(e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(e);r&&(o=o.filter(function(r){return Object.getOwnPropertyDescriptor(e,r).enumerable})),t.push.apply(t,o);}return t}function _objectSpread(e){for(var t,r=1;r<arguments.length;r++)t=null==arguments[r]?{}:arguments[r],r%2?ownKeys(Object(t),!0).forEach(function(r){_defineProperty(e,r,t[r]);}):Object.getOwnPropertyDescriptors?Object.defineProperties(e,Object.getOwnPropertyDescriptors(t)):ownKeys(Object(t)).forEach(function(r){Object.defineProperty(e,r,Object.getOwnPropertyDescriptor(t,r));});return e}function _defineProperty(obj,key,value){return key=_toPropertyKey(key),key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _toPropertyKey(t){var i=_toPrimitive(t,"string");return "symbol"==_typeof(i)?i:i+""}function _toPrimitive(t,r){if("object"!=_typeof(t)||!t)return t;var e=t[Symbol.toPrimitive];if(void 0!==e){var i=e.call(t,r||"default");if("object"!=_typeof(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return ("string"===r?String:Number)(t)}//http://stackoverflow.com/questions/946534/insert-text-into-textarea-with-jquery
Settings_Workflows_Edit_Js("Settings_Workflows_Edit3_Js",{},{step3Container:!1,advanceFilterInstance:!1,conditionBuilderInstance:!1,ckEditorInstance:!1,fieldValueMap:!1,init:function init(){this.initialize();},/**
		 * Function to get the container which holds all the reports step1 elements
		 * @return jQuery object
		 */getContainer:function getContainer(){return this.step3Container},/**
		 * Function to set the reports step1 container
		 * @params : element - which represents the reports step1 container
		 * @return : current instance
		 */setContainer:function setContainer(element){return this.step3Container=element,this},/**
		 * Function  to intialize the reports step1
		 */initialize:function initialize(container){"undefined"==typeof container&&(container=$("#workflow_step3")),container.is("#workflow_step3")?this.setContainer(container):this.setContainer($("#workflow_step3"));},registerEditTaskEvent:function registerEditTaskEvent(){var thisInstance=this,container=this.getContainer();container.on("click","[data-url]",function(e){var currentElement=$(e.currentTarget),params=currentElement.data("url"),progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});app.showModalWindow(null,params,function(data){if(progressIndicatorElement.progressIndicator({mode:"hide"}),data){var clipboard=App.Fields.Text.registerCopyClipboard(data);container.one("hidden.bs.modal",function(){clipboard.destroy();});}thisInstance.registerVTCreateTodoTaskEvents();var taskType=$("#taskType").val(),functionName="register"+taskType+"Events";"undefined"!=typeof thisInstance[functionName]&&thisInstance[functionName].apply(thisInstance,data),thisInstance.registerSaveTaskSubmitEvent(taskType),$("#saveTask").validationEngine(app.validationEngineOptions),thisInstance.registerFillTaskFieldsEvent(),thisInstance.registerCheckSelectDateEvent(),App.Tools.VariablesPanel.registerRefreshCompanyVariables(data),thisInstance.conditionBuilderInstance=new Vtiger_ConditionBuilder_Js(data.find(".js-condition-builder"),data.find(".js-source-module").val()),thisInstance.conditionBuilderInstance.registerEvents();});});},registerCheckSelectDateEvent:function registerCheckSelectDateEvent(){$("[name=\"check_select_date\"]").on("change",function(e){$(e.currentTarget).is(":checked")?$("#checkSelectDateContainer").removeClass("d-none").addClass("show"):$("#checkSelectDateContainer").removeClass("show").addClass("d-none");});},/**
		 * Register save task submit event
		 * @param {string} taskType
		 */registerSaveTaskSubmitEvent:function registerSaveTaskSubmitEvent(taskType){var _this=this;$("#saveTask").on("submit",function(e){var form=$(e.currentTarget);if(!0===form.validationEngine("validate")){var customValidationFunctionName=taskType+"CustomValidation";if("undefined"!=typeof _this[customValidationFunctionName]){var result=_this[customValidationFunctionName].apply(_this);if(!0!==result)return app.showNotify({title:app.vtranslate("JS_MESSAGE"),text:result,type:"error"}),void e.preventDefault()}var preSaveActionFunctionName="preSave"+taskType;"undefined"!=typeof _this[preSaveActionFunctionName]&&_this[preSaveActionFunctionName].apply(_this,[taskType]);var formData=form.serializeFormData(),createEntityModule=form.find(".createEntityModule:visible option:selected");formData.entity_type=createEntityModule.val(),formData.relationId=createEntityModule.attr("data-relation-id"),AppConnector.request(formData).done(function(data){data.result&&(_this.getTaskList(),app.hideModalWindow());});}e.preventDefault();});},VTUpdateFieldsTaskCustomValidation:function VTUpdateFieldsTaskCustomValidation(){return this.checkDuplicateFieldsSelected()},VTCreateEntityTaskCustomValidation:function VTCreateEntityTaskCustomValidation(){return this.checkDuplicateFieldsSelected()},checkDuplicateFieldsSelected:function checkDuplicateFieldsSelected(){var selectedFieldNames=$("#save_fieldvaluemapping").find(".js-conditions-row").find("[name=\"fieldname\"]"),result=!0,failureMessage=app.vtranslate("JS_SAME_FIELDS_SELECTED_MORE_THAN_ONCE");return $.each(selectedFieldNames,function(i,ele){var fieldName=$(ele).attr("value"),fields=$("[name="+fieldName+"]").not(":hidden");if(1<fields.length)return result=failureMessage,!1}),result},preSaveVTUpdateFieldsTask:function preSaveVTUpdateFieldsTask(tasktype){var values=this.getValues(tasktype);$("[name=\"field_value_mapping\"]").val(JSON.stringify(values));},preSaveVTCreateEntityTask:function preSaveVTCreateEntityTask(tasktype){var values=this.getValues(tasktype);$("[name=\"field_value_mapping\"]").val(JSON.stringify(values));},preSaveVTEmailTask:function preSaveVTEmailTask(){$("#content").val($("#saveTask").serializeFormData().content);},preSaveVTUpdateRelatedFieldTask:function preSaveVTUpdateRelatedFieldTask(tasktype){var values=this.getValues(tasktype);$("[name=\"field_value_mapping\"]").val(JSON.stringify(values));},preSaveSumFieldFromDependent:function preSaveSumFieldFromDependent(){$("[name=\"conditions\"]").val(JSON.stringify(this.conditionBuilderInstance.getConditions()));},/**
		 * Function to check if the field selected is empty field
		 * @params : select element which represents the field
		 * @return : boolean true/false
		 */isEmptyFieldSelected:function isEmptyFieldSelected(fieldSelect){var selectedOption=fieldSelect.find("option:selected");//assumption that empty field will be having value none
return !("none"!==selectedOption.val()&&selectedOption.val())},getVTCreateEntityTaskFieldList:function getVTCreateEntityTaskFieldList(){return new Array("fieldname","value","valuetype","modulename")},getVTUpdateFieldsTaskFieldList:function getVTUpdateFieldsTaskFieldList(){return new Array("fieldname","value","valuetype")},getVTUpdateRelatedFieldTaskFieldList:function getVTUpdateRelatedFieldTaskFieldList(){return new Array("fieldname","value","valuetype")},/**
		 * Get values
		 * @param {string} tasktype
		 * @returns {Array}
		 */getValues:function getValues(tasktype){var _this2=this,fieldListFunctionName="get"+tasktype+"FieldList",fieldList=[];"undefined"!=typeof this[fieldListFunctionName]&&(fieldList=this[fieldListFunctionName].apply());var values=[];return $(".js-conditions-row",$("#save_fieldvaluemapping")).each(function(i,conditionDomElement){var rowElement=$(conditionDomElement),fieldSelectElement=$("[name=\"fieldname\"]",rowElement),valueSelectElement=$("[data-value=\"value\"]",rowElement);//To not send empty fields to server
if(_this2.isEmptyFieldSelected(fieldSelectElement))return !0;var key,field,fieldDataInfo=fieldSelectElement.find("option:selected").data("fieldinfo"),fieldType=fieldDataInfo.type,rowValues={};if("owner"===fieldType)for(key in fieldList)field=fieldList[key],rowValues[field]="value"==field&&valueSelectElement.is("select")?valueSelectElement.find("option:selected").val():$("[name=\""+field+"\"]",rowElement).val();else if("picklist"===fieldType||"multipicklist"==fieldType){for(key in fieldList)if(field=fieldList[key],"value"===field&&valueSelectElement.is("input")){for(var pickListValues=valueSelectElement.data("picklistvalues"),valuesArr=valueSelectElement.val().split(","),newValuesArr=[],j=0;j<valuesArr.length;j++)"undefined"==typeof pickListValues[valuesArr[j]]?newValuesArr.push(valuesArr[j]):newValuesArr.push(pickListValues[valuesArr[j]]);rowValues[field]=newValuesArr.join(",");}else if("value"===field&&valueSelectElement.is("select")&&"picklist"==fieldType)rowValues[field]=valueSelectElement.val();else if("value"===field&&valueSelectElement.is("select")&&"multipicklist"==fieldType){var value=valueSelectElement.val();rowValues[field]=null===value?value:value.join(",");}else rowValues[field]=$("[name=\""+field+"\"]",rowElement).val();}else for(key in fieldList)field=fieldList[key],rowValues[field]="value"==field?valueSelectElement.val():$("[name=\""+field+"\"]",rowElement).val();("false"==$("[name=\"valuetype\"]",rowElement).val()||0==$("[name=\"valuetype\"]",rowElement).length)&&(rowValues.valuetype="rawtext"),values.push(rowValues);}),values},getTaskList:function getTaskList(){var _this3=this,container=this.getContainer(),params={module:app.getModuleName(),parent:app.getParentModuleName(),view:"TasksList",record:$("[name=\"record\"]",container).val()},progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request(params).done(function(data){$("#taskListContainer").html(data),progressIndicatorElement.progressIndicator({mode:"hide"}),_this3.registerSortWorkflowActionsTasks();});},registerTaskStatusChangeEvent:function registerTaskStatusChangeEvent(){var container=this.getContainer();container.on("change",".taskStatus",function(e){var currentStatusElement=$(e.currentTarget),url=currentStatusElement.data("statusurl");url+=currentStatusElement.is(":checked")?"&status=true":"&status=false";var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request(url).done(function(data){if("ok"==data.result){var params={title:app.vtranslate("JS_MESSAGE"),text:app.vtranslate("JS_STATUS_CHANGED_SUCCESSFULLY"),type:"success"};app.showNotify(params);}progressIndicatorElement.progressIndicator({mode:"hide"});}),e.stopImmediatePropagation();});},registerTaskDeleteEvent:function registerTaskDeleteEvent(){var thisInstance=this,container=this.getContainer();container.on("click",".deleteTask",function(e){app.showConfirmModal({title:app.vtranslate("LBL_DELETE_CONFIRMATION"),confirmedCallback:function confirmedCallback(){var currentElement=$(e.currentTarget),deleteUrl=currentElement.data("deleteurl");AppConnector.request(deleteUrl).done(function(data){"ok"==data.result&&(thisInstance.getTaskList(),app.showNotify({title:app.vtranslate("JS_MESSAGE"),text:app.vtranslate("JS_TASK_DELETED_SUCCESSFULLY"),type:"success"}));});}});});},registerFillTaskFromEmailFieldEvent:function registerFillTaskFromEmailFieldEvent(){$("#saveTask").on("change","#fromEmailOption",function(e){var currentElement=$(e.currentTarget),inputElement=currentElement.closest(".row").find(".fields");inputElement.val(currentElement.val());});},registerFillTaskFieldsEvent:function registerFillTaskFieldsEvent(){$("#saveTask").on("change",".task-fields",function(e){var currentElement=$(e.currentTarget),inputElement=currentElement.closest(".row").find(".fields"),oldValue=inputElement.val()||"",data=[];data[0]=oldValue,data[1]=currentElement.val(),data=data.filter(function(field){return !!field}),inputElement.val(data.join(","));});},registerVTEmailTaskEvents:function registerVTEmailTaskEvents(){var textAreaElement=$("#content");new App.Fields.Text.Editor(textAreaElement),this.registerFillTaskFromEmailFieldEvent(),this.registerCcAndBccEvents();},registerVTCreateTodoTaskEvents:function registerVTCreateTodoTaskEvents(){app.registerEventForClockPicker();},registerVTUpdateFieldsTaskEvents:function registerVTUpdateFieldsTaskEvents(){var thisInstance=this;this.registerAddFieldEvent(),this.registerDeleteConditionEvent(),this.registerFieldChange(),this.fieldValueMap=!1,""!=$("#fieldValueMapping").val()&&this.fieldValueReMapping();var fields=$("#save_fieldvaluemapping").find("select[name=\"fieldname\"]");$.each(fields,function(i,field){thisInstance.loadFieldSpecificUi($(field));}),this.getPopUp($("#saveTask"));},registerVTUpdateRelatedFieldTaskEvents:function registerVTUpdateRelatedFieldTaskEvents(container){var thisInstance=this;this.registerAddFieldEvent(),this.registerDeleteConditionEvent(),this.registerConditionsModal($(container)),this.registerFieldChange(),this.fieldValueMap=!1,""!=$("#fieldValueMapping").val()&&this.fieldValueReMapping();var fields=$("#save_fieldvaluemapping").find("select[name=\"fieldname\"]");$.each(fields,function(i,field){thisInstance.loadFieldSpecificUi($(field));}),this.getPopUp($("#saveTask"));},/**
		 * Add field
		 * @param {jQuery|null} replaceElement - if we want to replace existing field container with new one
		 */addField:function addField(){var replaceElement=0<arguments.length&&arguments[0]!==void 0?arguments[0]:null,newAddFieldContainer=$(".js-add-basic-field-container").clone(!0,!0).removeClass("js-add-basic-field-container d-none").addClass("js-conditions-row");//change in to select elements
$("select",newAddFieldContainer).addClass("select2"),null===replaceElement?$("#save_fieldvaluemapping").append(newAddFieldContainer):replaceElement.replaceWith(newAddFieldContainer),App.Fields.Picklist.changeSelectElementView(newAddFieldContainer);},/**
		 * Register add field event
		 */registerAddFieldEvent:function registerAddFieldEvent(){var _this4=this;$("#addFieldBtn").on("click",function(){_this4.addField();});},registerDeleteConditionEvent:function registerDeleteConditionEvent(){$("#saveTask").on("click",".js-condition-delete",function(e){$(e.currentTarget).closest(".js-conditions-row").remove();});},/**
		 * Register condition wizard
		 * @param {jQuery} container
		 */registerConditionsModal:function registerConditionsModal(container){container.on("click",".js-condition-modal",function(e){var element=$(e.currentTarget),fieldValue=element.closest(".js-conditions-row").find("[name=\"fieldname\"]").val(),sourceField=container.find(".js-condition-value");if(fieldValue&&!(0>=sourceField.length)){var moduleName,value=sourceField.val()?_objectSpread({},JSON.parse(sourceField.val())):{},fieldValueParts=fieldValue.split("::");moduleName=2===fieldValueParts.length?fieldValueParts[0]:fieldValueParts[1],AppConnector.request({module:app.getModuleName(),parent:app.getParentModuleName(),view:"ConditionBuilder",mode:"builder",sourceModuleName:moduleName,relatedModuleSkip:!0,advanceCriteria:value[fieldValue]||[]}).done(function(data){app.showModalHtml({class:"modal-lg",header:element.attr("title"),headerIcon:"fas fa-filter",body:data,footerButtons:[{text:app.vtranslate("JS_APPLY"),icon:"fas fa-check",class:"btn-primary js-condition-apply"},{text:app.vtranslate("JS_CANCEL"),icon:"fas fa-times",class:"btn-outline-primary",data:{dismiss:"modal"}}],cb:function cb(modal){var conditionBuilder=new Vtiger_ConditionBuilder_Js(modal.find(".js-condition-builder"),{sourceModuleName:moduleName,relatedModuleSkip:!0});conditionBuilder.registerEvents(),modal.on("click",".js-condition-apply",function(){var conditions=conditionBuilder.getConditions(!0);conditions&&Object.keys(conditions).length?value[fieldValue]=conditions:"undefined"!=typeof value[fieldValue]&&delete value[fieldValue],sourceField.val(JSON.stringify(value)),app.hideModalWindow(!1,modal.closest(".js-modal-container").attr("id"));});}});});}});},/**
		 * Function which will register field change event
		 */registerFieldChange:function registerFieldChange(){var _this5=this;$("#saveTask").on("change","select[name=\"fieldname\"]",function(e){var selectedElement=$(e.currentTarget),conditionRow=selectedElement.closest(".js-conditions-row");if("none"!==selectedElement.val()&&selectedElement.val()){var moduleNameElement=conditionRow.find("[name=\"modulename\"]");if(0<moduleNameElement.length){var workflowModuleName=selectedElement.closest("form").find("#workflowModuleName").val(),selectedOption=selectedElement.find("option:selected"),selectedOptionFieldInfo=selectedOption.data("fieldinfo"),type=selectedOptionFieldInfo.type;if("picklist"==type||"multipicklist"==type){var selectElement=$("select.createEntityModule:not(:disabled)"),moduleName=selectElement.val();moduleNameElement.val(moduleName).change().prop("disabled",!0);}else selectedOption.data("reference")&&moduleNameElement.find("option[value=\"".concat(workflowModuleName,"\"]")).length?moduleNameElement.val(workflowModuleName).change().prop("disabled",!0):moduleNameElement.prop("disabled",!1);}_this5.loadFieldSpecificUi(selectedElement);}else _this5.addField(conditionRow);});},getModuleName:function getModuleName(){return app.getModuleName()},getFieldValueMapping:function getFieldValueMapping(){var fieldValueMap=this.fieldValueMap;return !1==fieldValueMap?"":fieldValueMap},fieldValueReMapping:function fieldValueReMapping(){var object=JSON.parse($("#fieldValueMapping").val()),fieldValueReMap={};$.each(object,function(i,array){fieldValueReMap[array.fieldname]={};var values={};$.each(array,function(key,value){values[key]=value;}),fieldValueReMap[array.fieldname]=values;}),this.fieldValueMap=fieldValueReMap;},/**
		 * Load field specific UI
		 * @param {jQuery} fieldSelect
		 * @returns this
		 */loadFieldSpecificUi:function loadFieldSpecificUi(fieldSelect){var selectedOption=fieldSelect.find("option:selected"),row=fieldSelect.closest("div.js-conditions-row"),fieldUiHolder=row.find(".fieldUiHolder"),fieldInfo=selectedOption.data("fieldinfo"),fieldValueMapping=this.getFieldValueMapping(),selectField="";fieldValueMapping&&"undefined"!=typeof fieldValueMapping[fieldInfo.name]?selectField=fieldValueMapping[fieldInfo.name]:fieldValueMapping&&"undefined"!=typeof fieldValueMapping[fieldSelect.val()]&&(selectField=fieldValueMapping[fieldSelect.val()]),selectField?(fieldInfo.value=selectField.value,fieldInfo.workflow_valuetype=selectField.valuetype):fieldInfo.workflow_valuetype="rawtext";var moduleName=this.getModuleName(),fieldModel=Vtiger_Field_Js.getInstance(fieldInfo,moduleName);this.fieldModelInstance=fieldModel;var fieldSpecificUi=this.getFieldSpecificUi(fieldSelect),fieldName=fieldModel.getName();//remove validation since we dont need validations for all eleements
// Both filter and find is used since we dont know whether the element is enclosed in some conainer like currency
"multipicklist"==fieldModel.getType()&&(fieldName+="[]"),fieldSpecificUi.filter("[name=\""+fieldName+"\"]").attr("data-value","value"),fieldSpecificUi.find("[name=\""+fieldName+"\"]").attr("data-value","value"),fieldSpecificUi.filter("[name=\"valuetype\"]").removeAttr("data-validation-engine"),fieldSpecificUi.find("[name=\"valuetype\"]").removeAttr("data-validation-engine");//If the workflowValueType is rawtext then only validation should happen
var workflowValueType=fieldSpecificUi.filter("[name=\"valuetype\"]").val();if("rawtext"!=workflowValueType&&"undefined"!=typeof workflowValueType&&(fieldSpecificUi.filter("[name=\""+fieldName+"\"]").removeAttr("data-validation-engine"),fieldSpecificUi.find("[name=\""+fieldName+"\"]").removeAttr("data-validation-engine")),fieldUiHolder.html(fieldSpecificUi),fieldSpecificUi.is("input.select2")||fieldSpecificUi.is("select")){var params={allowClear:fieldInfo&&!1===fieldInfo.mandatory};App.Fields.Picklist.showSelect2ElementView(fieldSpecificUi,params);}else fieldSpecificUi.is("input.dateField")?App.Fields.Date.register(fieldSpecificUi):fieldSpecificUi.is("input.dateRangeField")&&App.Fields.Date.registerRange(fieldSpecificUi,{ranges:!1});return this},/**
		 * Functiont to get the field specific ui for the selected field
		 * @prarms : fieldSelectElement - select element which will represents field list
		 * @return : jquery object which represents the ui for the field
		 */getFieldSpecificUi:function getFieldSpecificUi(){var fieldModel=this.fieldModelInstance;return $(fieldModel.getUiTypeSpecificHtml())},registerVTCreateEventTaskEvents:function registerVTCreateEventTaskEvents(){app.registerEventForClockPicker();},registerVTCreateEntityTaskEvents:function registerVTCreateEntityTaskEvents(){this.registerChangeCreateEntityEvent(),this.registerVTUpdateFieldsTaskEvents();},/**
		 * Register record collector events.
		 */registerRecordCollectorEvents:function registerRecordCollectorEvents(){var recordCollector=$("[name=\"recordCollector\"]"),selectedFields=$(".js-fields-map");recordCollector.on("change",function(){var fieldsMap="";if(recordCollector.find(".js-fields").each(function(_,e){var row=$(e);row.data("fields")&&row.is(":checked")&&(fieldsMap=row.data("fields"));}),""!==fieldsMap&&selectedFields.is("select")){var newOptions=new $;$.each(fieldsMap,function(v,l){newOptions=newOptions.add(new Option(l,v,!1));}),selectedFields.html(newOptions);}}),recordCollector.val()&&1>selectedFields.val().length&&recordCollector.trigger("change");},registerChangeCreateEntityEvent:function registerChangeCreateEntityEvent(){var thisInstance=this;$("[name=\"mappingPanel\"]").on("change",function(e){var currentTarget=$(e.currentTarget);app.setMainParams("mappingPanel",currentTarget.val()),$("#addCreateEntityContainer").html("");var hideElementByClass=$("."+currentTarget.data("hide")),showElementByClass=$("."+currentTarget.data("show")),taskFields=app.getMainParams("taskFields",!0);hideElementByClass.addClass("d-none").find("input,select").each(function(){var element=$(this),name=element.attr("name");0<=$.inArray(name,taskFields)&&(element.is("select")&&element.val("").trigger("change"),element.prop("disabled",!0));}),showElementByClass.removeClass("d-none").find("input,select").each(function(){var element=$(this),name=element.attr("name");0<=$.inArray(name,taskFields)&&(element.prop("disabled",!1),element.is("select")&&element.val("").trigger("change"));});}),$(".createEntityModule").on("change",function(e){var params={module:app.getModuleName(),parent:app.getParentModuleName(),view:"CreateEntity",for_workflow:$("[name=\"for_workflow\"]").val(),mappingPanel:app.getMainParams("mappingPanel")},relatedModule=$(e.currentTarget).val();relatedModule&&(params.relatedModule=relatedModule);var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});AppConnector.request(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"});var createEntityContainer=$("#addCreateEntityContainer");createEntityContainer.html(data),App.Fields.Picklist.changeSelectElementView(createEntityContainer),App.Fields.Picklist.showSelect2ElementView(createEntityContainer.find(".select2")),thisInstance.registerAddFieldEvent(),thisInstance.fieldValueMap=!1,""!=$("#fieldValueMapping").val()&&this.fieldValueReMapping();var fields=$("#save_fieldvaluemapping").find("select[name=\"fieldname\"]");$.each(fields,function(i,field){thisInstance.loadFieldSpecificUi($(field));});});});},/**
		 * Function which will change the UI styles based on recurring type
		 * @params - recurringType - which recurringtype is selected
		 */changeRecurringTypesUIStyles:function changeRecurringTypesUIStyles(recurringType){"Daily"==recurringType||"Yearly"==recurringType?($("#repeatWeekUI").removeClass("show").addClass("d-none"),$("#repeatMonthUI").removeClass("show").addClass("d-none")):"Weekly"==recurringType?($("#repeatWeekUI").removeClass("d-none").addClass("show"),$("#repeatMonthUI").removeClass("show").addClass("d-none")):"Monthly"==recurringType&&($("#repeatWeekUI").removeClass("show").addClass("d-none"),$("#repeatMonthUI").removeClass("d-none").addClass("show"));},checkHiddenStatusofCcandBcc:function checkHiddenStatusofCcandBcc(){var ccLink=$("#ccLink"),bccLink=$("#bccLink");ccLink.hasClass("d-none")&&bccLink.hasClass("d-none")&&ccLink.closest("div.row").addClass("d-none");},/*
		 * Function to register the events for bcc and cc links
		 */registerCcAndBccEvents:function registerCcAndBccEvents(){var thisInstance=this;$("#ccLink").on("click",function(e){var ccContainer=$("#ccContainer");ccContainer.removeClass("d-none");var taskFieldElement=ccContainer.find("select.task-fields");taskFieldElement.addClass("select2"),App.Fields.Picklist.changeSelectElementView(taskFieldElement),$(e.currentTarget).addClass("d-none"),thisInstance.checkHiddenStatusofCcandBcc();}),$("#bccLink").on("click",function(e){var bccContainer=$("#bccContainer");bccContainer.removeClass("d-none");var taskFieldElement=bccContainer.find("select.task-fields");taskFieldElement.addClass("select2"),App.Fields.Picklist.changeSelectElementView(taskFieldElement),$(e.currentTarget).addClass("d-none"),thisInstance.checkHiddenStatusofCcandBcc();});},/**
		 * Register sortable
		 */registerSortWorkflowActionsTasks:function registerSortWorkflowActionsTasks(){var _this6=this,tasks=this.container.find(".js-workflow-tasks-list");tasks.sortable({containment:tasks,items:tasks.find(".js-workflow-task"),handle:".js-drag",revert:!0,tolerance:"pointer",cursor:"move",classes:{"ui-sortable-helper":"bg-light"},helper:function helper(_e,ui){return ui.children().each(function(_index,element){element=$(element),element.width(element.width());}),ui},update:function update(){_this6.saveSequence();}});},/**
		 * Save sequence
		 */saveSequence:function saveSequence(){var tasks=[];this.container.find(".js-workflow-task").each(function(index){tasks[index]=$(this).data("id");}),AppConnector.request({module:this.container.find("[name=\"module\"]").length?this.container.find("[name=\"module\"]").val():app.getModuleName(),parent:app.getParentModuleName(),action:"SaveAjax",mode:"sequenceTasks",tasks:tasks}).done(function(data){data.result.message&&app.showNotify({text:data.result.message});}).fail(function(){app.showNotify({text:app.vtranslate("JS_UNEXPECTED_ERROR"),type:"error"});});},registerEvents:function registerEvents(){this.container=this.getContainer(),App.Fields.Picklist.changeSelectElementView(this.container),this.registerEditTaskEvent(),this.registerTaskStatusChangeEvent(),this.registerTaskDeleteEvent(),this.registerSortWorkflowActionsTasks();}}),$.fn.extend({insertAtCaret:function insertAtCaret(myValue){return this.each(function(){if(document.selection){this.focus();var sel=document.selection.createRange();sel.text=myValue,this.focus();}else if(this.selectionStart||"0"==this.selectionStart){//For browsers like Firefox and Webkit based
var startPos=this.selectionStart,endPos=this.selectionEnd,scrollTop=this.scrollTop;this.value=this.value.substring(0,startPos)+myValue+this.value.substring(endPos,this.value.length),this.focus(),this.selectionStart=startPos+myValue.length,this.selectionEnd=startPos+myValue.length,this.scrollTop=scrollTop;}else this.value+=myValue,this.focus();})}});
//# sourceMappingURL=Edit3.min.js.map
