'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";jQuery.Class("OpenStreetMap_Map_Js",{},{container:!1,mapInstance:!1,selectedParams:!1,layerMarkers:!1,markers:!1,cacheMarkers:[],polygonLayer:!1,routeLayer:!1,recordsIds:"",cacheLayerMarkers:{},indirectPointLayer:{},fieldInstance:void 0,isPanelRegistered:!1,setSelectedParams:function setSelectedParams(params){delete params.view,this.selectedParams=params;},registerMap:function registerMap(startCoordinate,startZoom){this.mapInstance=L.map("mapid").setView(startCoordinate,startZoom);var tileLayerServer=$(".js-tile-layer-server").val();return tileLayerServer.includes("maps.googleapis.com")?this.registerGoogleMap(tileLayerServer):this.registerOpenStreetMap(tileLayerServer)},registerGoogleMap:function registerGoogleMap(tileLayerServer){var mapsLoadedPromise=this._deferredPromise(this.mapInstance);if(mapsLoadedPromise.then(function(mapInstance){L.gridLayer.googleMutant({type:"roadmap"}).addTo(mapInstance);}),"undefined"!=typeof googleMapsLoaded)return mapsLoadedPromise.resolve(this.mapInstance),mapsLoadedPromise;window.googleMapsLoaded=function(){return mapsLoadedPromise.resolve(mapsLoadedPromise.value)};var mapsScript=document.createElement("script");return mapsScript.src=tileLayerServer+"&callback=googleMapsLoaded",mapsScript.async=!0,document.head.appendChild(mapsScript),mapsLoadedPromise},registerOpenStreetMap:function registerOpenStreetMap(tileLayerServer){var attribution="&copy; <a href=\"https://yetiforce.com/en/yetiforce/license\" rel=\"noreferrer noopener\">YetiForce Map powered by Open Street Map</a>";return CONFIG.disableBranding&&(attribution=""),L.tileLayer(tileLayerServer,{maxZoom:19,attribution:attribution}).addTo(this.mapInstance),Promise.resolve(this.mapInstance)},setMarkers:function setMarkers(data){var _this=this,thisInstance=this,markerArray=[],container=this.container,map=this.mapInstance;if("undefined"!=typeof data.coordinates){var markers=L.markerClusterGroup({maxClusterRadius:10});"boolean"!=typeof this.layerMarkers&&map.removeLayer(this.layerMarkers);var records=[];data.coordinates.forEach(function(e){if(null!==e.lat&&null!==e.lon){markerArray.push([e.lat,e.lon]);var marker=L.marker([e.lat,e.lon],{icon:thisInstance.createMarkerIconFromResponse(e,"blue")}).bindPopup(e.label);markers.addLayer(marker),records.push(e.recordId);}}),this.recordsIds=records,this.markers=data.coordinates,this.layerMarkers=markers,map.addLayer(markers);}if("boolean"!=typeof this.polygonLayer&&map.removeLayer(this.polygonLayer),"undefined"!=typeof data.coordinatesCenter)if("undefined"==typeof data.coordinatesCenter.error){var radius=container.find(".js-radius").val();markerArray.push([data.coordinatesCenter.lat,data.coordinatesCenter.lon]);var marker=L.marker([data.coordinatesCenter.lat,data.coordinatesCenter.lon],{icon:L.AwesomeMarkers.icon({icon:"search",markerColor:"red",prefix:"fa"})}).bindPopup(this.getMarkerPopup(container.find(".js-search-address").val(),data.coordinatesCenter,this.isPanelRegistered,!0));if(map.addLayer(marker),marker.openPopup(),$.isNumeric(radius)){radius=1e3*parseInt(radius);var circle=L.circle([data.coordinatesCenter.lat,data.coordinatesCenter.lon],radius,{color:"red",fillColor:"#f03",fillOpacity:.05});this.polygonLayer=L.featureGroup([circle]),map.addLayer(this.polygonLayer);}}else Vtiger_Helper_Js.showMessage({title:app.vtranslate("JS_LBL_PERMISSION"),text:data.coordinatesCenter.error,type:"error"});"undefined"!=typeof data.cache&&Object.keys(data.cache).forEach(function(key){"undefined"!=typeof thisInstance.cacheLayerMarkers[key]&&map.removeLayer(thisInstance.cacheLayerMarkers[key]);var markersCache=L.markerClusterGroup({maxClusterRadius:10}),coordinates=data.cache[key];coordinates.forEach(function(e){if(-1===thisInstance.recordsIds.indexOf(e.recordId)&&null!==e.lat&&null!==e.lon){markerArray.push([e.lat,e.lon]);var marker=L.marker([e.lat,e.lon],{icon:_this.createMarkerIconFromResponse(e,"orange")}).bindPopup(e.label);markersCache.addLayer(marker);}}),thisInstance.cacheMarkers[key]=coordinates,map.addLayer(markersCache),thisInstance.cacheLayerMarkers[key]=markersCache;}),this.addLegend(null===data||void 0===data?void 0:data.legend),markerArray.length&&map.fitBounds(markerArray),this.container.find(".groupNeighbours").prop("checked",!0);},addLegend:function addLegend(legend){var legendContainer=this.container.find(".js-legend-container");if("undefined"!=typeof legend){var html="";legend.forEach(function(e){html+="<div class=\"float-left mt-2\"><span class=\"leegendIcon mt-1\" style=\"background:"+e.color+"\"></span> "+e.value+"</div>";}),legendContainer.html(html);}else legendContainer.html("");},showCalculateBtn:function showCalculateBtn(){var container=this.container,endAddress=container.find(".end").val(),startAddress=container.find(".start").val();0<endAddress.length&&0<startAddress.length&&container.find(".js-calculate-route").parent().removeClass("d-none");},registerCacheEvents:function registerCacheEvents(container){var _this2=this,thisInstance=this;container.find(".showRecordsFromCache").on("change",function(e){var currentTarget=$(e.currentTarget),moduleName=currentTarget.data("module");currentTarget.is(":checked")?AppConnector.request({module:"OpenStreetMap",action:"GetMarkers",srcModule:app.getModuleName(),cache:[moduleName]}).done(function(response){_this2.setMarkers(response.result);}):_this2.cacheLayerMarkers.hasOwnProperty(moduleName)&&_this2.mapInstance.removeLayer(_this2.cacheLayerMarkers[moduleName]);}),container.find(".copyToClipboard").on("click",function(){var params={module:"OpenStreetMap",action:"ClipBoard",mode:"save",recordIds:JSON.stringify(thisInstance.recordsIds),srcModule:app.getModuleName()};AppConnector.request(params).done(function(response){Vtiger_Helper_Js.showMessage({text:app.vtranslate("JS_NOTIFY_COPY_TEXT"),type:"success"});var countRecords=container.find(".countRecords"+app.getModuleName());countRecords.html(response.result),countRecords.closest(".cacheModuleContainer").find(".js-delete-clip-board").removeClass("d-none");});}),container.find(".js-delete-clip-board").on("click",function(e){var currentTarget=$(e.currentTarget),moduleName=currentTarget.data("module");AppConnector.request({module:"OpenStreetMap",action:"ClipBoard",mode:"delete",srcModule:moduleName}).done(function(){Vtiger_Helper_Js.showMessage({title:app.vtranslate("JS_LBL_PERMISSION"),text:app.vtranslate("JS_SAVE_NOTIFY_OK"),type:"success"});var countRecords=container.find(".countRecords"+moduleName);countRecords.html(""),currentTarget.addClass("d-none"),countRecords.closest(".cacheModuleContainer").find(".showRecordsFromCache").prop("checked",!1),countRecords.closest(".cacheModuleContainer").find(".showRecordsFromCache").trigger("change");});}),container.find(".addAllRecords").on("click",function(e){var currentTarget=$(e.currentTarget),moduleName=currentTarget.data("module");AppConnector.request({module:"OpenStreetMap",action:"ClipBoard",mode:"addAllRecords",srcModule:moduleName}).done(function(response){Vtiger_Helper_Js.showMessage({text:app.vtranslate("JS_MESSAGE_DOWNLOADED_ADDRESS_DATA"),type:"success"}),container.find(".countRecords"+moduleName).html(response.result.count);var moduleContainer=currentTarget.closest(".cacheModuleContainer");moduleContainer.find(".showRecordsFromCache").prop("checked",!0),moduleContainer.find(".showRecordsFromCache").trigger("change"),"0"!=response.result.count&&moduleContainer.find(".js-delete-clip-board").removeClass("d-none");});});},getCacheParamsToRequest:function getCacheParamsToRequest(){var params=[];return this.container.find(".showRecordsFromCache").each(function(){var currentObject=$(this);currentObject.is(":checked")&&params.push(currentObject.data("module"));}),params},registerSearchCompany:function registerSearchCompany(){var _this3=this,searchValue=this.container.find(".js-search-company"),searchModule=this.container.find(".searchModule");$.widget("custom.ivAutocomplete",$.ui.autocomplete,{_create:function _create(){this._super(),this.widget().menu("option","items","> :not(.ui-autocomplete-category)");},_renderMenu:function _renderMenu(ul,items){var that=this,currentCategory="";$.each(items,function(_index,item){var li;item.category!==currentCategory&&(ul.append("<li class='ui-autocomplete-category'>"+item.category+"</li>"),currentCategory=item.category),li=that._renderItemData(ul,item),item.category&&li.attr("aria-label",item.category+" : "+item.label);});},_renderItemData:function _renderItemData(ul,item){return this._renderItem(ul,item).data("ui-autocomplete-item",item)},_renderItem:function _renderItem(ul,item){return $("<li>").data("item.autocomplete",item).append($("<a></a>").html(item.label)).appendTo(ul)}}),searchValue.ivAutocomplete({delay:"600",minLength:"3",source:function source(_request,response){AppConnector.request({module:searchModule.val(),currentModule:app.getModuleName(),searchModule:searchModule.val(),view:"BasicAjax",mode:"showSearchResults",value:searchValue.val(),html:!1}).done(function(responseAjax){responseAjax=JSON.parse(responseAjax);var responseDataList=responseAjax.result;0>=responseDataList.length&&responseDataList.push({label:app.vtranslate("JS_NO_RESULTS_FOUND"),type:"no results",category:""}),response(responseDataList);});},select:function select(_event,ui){_this3.recordsIds.push(ui.item.id),AppConnector.request({module:"OpenStreetMap",action:"ClipBoard",mode:"addRecord",record:ui.item.id,srcModuleName:searchModule.val()}).done(function(response){if("boolean"!=typeof _this3.layerMarkers&&(_this3.mapInstance.removeLayer(_this3.layerMarkers),_this3.layerMarkers=L.markerClusterGroup({maxClusterRadius:10})),0<response.result.coordinates.length){var _response$result,markerArray=[];response.result.coordinates.forEach(function(coords){markerArray.push([coords.lat,coords.lon]);var marker=L.marker([coords.lat,coords.lon],{icon:_this3.createMarkerIconFromResponse(coords)}).bindPopup(coords.label);_this3.layerMarkers.addLayer(marker),_this3.mapInstance.addLayer(_this3.layerMarkers);}),_this3.mapInstance.fitBounds(markerArray),_this3.addLegend(null===(_response$result=response.result)||void 0===_response$result?void 0:_response$result.legend);}else Vtiger_Helper_Js.showMessage({title:app.vtranslate("JS_LBL_PERMISSION"),text:response.result,type:"error"});});}});},registerSearchAddress:function registerSearchAddress(){var _this4=this,searchValue=this.container.find(".js-search-address"),searchBtn=this.container.find(".js-search-btn"),operator=this.container.find(".js-select-operator");operator.length&&operator.val()&&(searchValue.autocomplete({delay:600,minLength:3,source:function source(request,response){AppConnector.request({module:app.getModuleName(),action:"Fields",mode:"findAddress",type:operator.val(),value:request.term}).done(function(requestData){!1===requestData.result?app.showNotify({title:app.vtranslate("JS_ERROR"),type:"error"}):requestData.result.length?response(requestData.result):response([{label:app.vtranslate("JS_NO_RESULTS_FOUND"),value:""}]);}).fail(function(_textStatus,_errorThrown,jqXHR){app.showNotify({title:app.vtranslate("JS_ERROR"),text:jqXHR.responseJSON.error.message,type:"error",animation:"show"}),response([{label:app.vtranslate("JS_NO_RESULTS_FOUND"),value:""}]);});},select:function select(_event,ui){if(ui.item.coordinates){var marker=L.marker([ui.item.coordinates.lat,ui.item.coordinates.lon],{icon:L.AwesomeMarkers.icon({icon:"home",markerColor:"cadetblue",prefix:"fa"})}).bindPopup(_this4.getMarkerPopup(ui.item.label,ui.item.coordinates));_this4.layerMarkers.addLayer(marker),_this4.mapInstance.addLayer(_this4.layerMarkers),_this4.mapInstance.setView(new L.LatLng(ui.item.coordinates.lat,ui.item.coordinates.lon),10);}else searchValue.val(ui.item.label),searchBtn.trigger("click");}}).autocomplete("instance")._renderItem=function(ul,item){return $("<li>").append("<div><span class=\"fi fi-".concat(item.countryCode,"\"></span> ").concat(item.label,"</div>")).appendTo(ul)}),this.container.find(".js-search-address,.js-radius").on("keydown",function(e){"Enter"===e.code&&searchBtn.trigger("click");}),searchBtn.on("click",function(){var progressIndicatorElement=jQuery.progressIndicator({position:_this4.container,blockInfo:{enabled:!0}}),params={module:"OpenStreetMap",action:"GetMarkers",srcModule:app.getModuleName(),searchValue:_this4.container.find(".js-search-address").val(),cache:_this4.getCacheParamsToRequest()},radiusValue=_this4.container.find(".js-radius").val();""!==radiusValue&&parseInt(radiusValue)&&(params.radius=parseInt(radiusValue)),AppConnector.request($.extend(_this4.selectedParams,params)).done(function(response){progressIndicatorElement.progressIndicator({mode:"hide"}),_this4.setMarkers(response.result);});});},registerMyLocation:function registerMyLocation(){var _this5=this,locationBtn=this.container.find(".js-my-location-btn");return navigator.geolocation?void(navigator.permissions.query({name:"geolocation"}).then(function(response){"denied"===response.state&&locationBtn.addClass("d-none");}),locationBtn.on("click",function(){navigator.geolocation.getCurrentPosition(function(position){_this5.addMarker(position.coords.latitude,position.coords.longitude,_this5.getMarkerPopup(locationBtn.data("label"),{lat:position.coords.latitude,lon:position.coords.longitude},!1),L.AwesomeMarkers.icon({icon:"street-view",prefix:"fa"})),_this5.mapInstance.setView(new L.LatLng(position.coords.latitude,position.coords.longitude),12);});})):void locationBtn.addClass("d-none")},registerBasicModal:function registerBasicModal(){this.registerSearchAddress(),this.registerMyLocation();},registerPanel:function registerPanel(){var layer,description,_this6=this,thisInstance=this,container=this.container,map=this.mapInstance;app.registerBlockAnimationEvent(container),this.registerCacheEvents(container),container.find(".groupBy").on("click",function(){var progressIndicator=jQuery.progressIndicator({position:container,blockInfo:{enabled:!0}}),params={module:"OpenStreetMap",action:"GetMarkers",srcModule:app.getModuleName(),groupBy:container.find(".fieldsToGroup").val(),searchValue:container.find(".js-search-address").val(),radius:container.find(".js-radius").val(),cache:_this6.getCacheParamsToRequest()};params=$.extend(_this6.selectedParams,params),AppConnector.request(params).done(function(response){progressIndicator.progressIndicator({mode:"hide"}),_this6.setMarkers(response.result);});}),container.find(".groupNeighbours").on("change",function(group){var currentTarget=$(group.currentTarget);map.removeLayer(_this6.layerMarkers);var markers=_this6.markers;if(currentTarget.is(":checked"))layer=L.markerClusterGroup({maxClusterRadius:10}),markers.forEach(function(e){var marker=L.marker([e.lat,e.lon],{icon:L.AwesomeMarkers.icon({icon:"home",markerColor:"blue",prefix:"fa",iconColor:e.color})}).bindPopup(e.label);layer.addLayer(marker);}),Object.keys(_this6.cacheLayerMarkers).forEach(function(key){map.removeLayer(_this6.cacheLayerMarkers[key]);var cacheLayer=L.markerClusterGroup({maxClusterRadius:10});_this6.cacheMarkers[key].forEach(function(e){var marker=L.marker([e.lat,e.lon],{icon:thisInstance.createMarkerIconFromResponse(e,"orange")}).bindPopup(e.label);cacheLayer.addLayer(marker);}),_this6.cacheLayerMarkers[key]=cacheLayer,map.addLayer(cacheLayer);});else {var markerArray=[];markers.forEach(function(e){var marker=L.marker([e.lat,e.lon],{icon:L.AwesomeMarkers.icon({icon:"home",markerColor:"blue",prefix:"fa",iconColor:e.color})}).bindPopup(e.label);markerArray.push(marker);}),layer=L.featureGroup(markerArray),Object.keys(_this6.cacheLayerMarkers).forEach(function(key){map.removeLayer(_this6.cacheLayerMarkers[key]);var markerArray=[];_this6.cacheMarkers[key].forEach(function(e){var marker=L.marker([e.lat,e.lon],{icon:thisInstance.createMarkerIconFromResponse(e,"orange")}).bindPopup(e.label);markerArray.push(marker);}),_this6.cacheLayerMarkers[key]=L.featureGroup(markerArray),map.addLayer(_this6.cacheLayerMarkers[key]);});}_this6.layerMarkers=layer,map.addLayer(layer);});var startIconLayer=!1;container.on("click",".startTrack",function(e){startIconLayer&&map.removeLayer(startIconLayer);var currentTargetTrack=$(e.currentTarget),containerPopup=currentTargetTrack.closest(".leaflet-popup-content");description=containerPopup.find(".description").html();var startElement=container.find(".start"),coordinates=containerPopup.find(".coordinates");description=description.replace(/\<br\>/gi,", "),startElement.val(description),startElement.data("lat",coordinates.data("lat")),startElement.data("lon",coordinates.data("lon"));var marker=L.marker([coordinates.data("lat"),coordinates.data("lon")],{icon:L.AwesomeMarkers.icon({icon:"truck",markerColor:"green",prefix:"fa"})}).bindPopup(containerPopup.html());startIconLayer=L.featureGroup([marker]),map.addLayer(startIconLayer),_this6.showCalculateBtn();});var endIconLayer=!1;container.on("click",".endTrack",function(e){endIconLayer&&map.removeLayer(endIconLayer);var currentTargetTrack=$(e.currentTarget),containerPopup=currentTargetTrack.closest(".leaflet-popup-content");description=containerPopup.find(".description").html();var endElement=container.find(".end"),coordinates=containerPopup.find(".coordinates");description=description.replace(/\<br\>/gi,", "),endElement.val(description),endElement.data("lat",coordinates.data("lat")),endElement.data("lon",coordinates.data("lon"));var marker=L.marker([coordinates.data("lat"),coordinates.data("lon")],{icon:L.AwesomeMarkers.icon({icon:"flag-checkered",markerColor:"red",prefix:"fa"})}).bindPopup(containerPopup.html());endIconLayer=L.featureGroup([marker]),map.addLayer(endIconLayer),_this6.showCalculateBtn();}),container.on("click",".indirectPoint",function(e){var currentTarget=$(e.currentTarget),containerPopup=currentTarget.closest(".leaflet-popup-content");description=containerPopup.find(".description").html();var template=container.find(".indirectTemplate"),indirect=template.clone();template.before(indirect),indirect.removeClass("indirectTemplate"),indirect.removeClass("d-none");var coordinates=containerPopup.find(".coordinates");description=description.replace(/\<br\>/gi,", "),"undefined"!=typeof _this6.indirectPointLayer[description]&&map.removeLayer(_this6.indirectPointLayer[description]);var indirectField=indirect.find(".indirect");indirectField.val(description),indirectField.data("lat",coordinates.data("lat")),indirectField.data("lon",coordinates.data("lon"));var marker=L.marker([coordinates.data("lat"),coordinates.data("lon")],{icon:L.AwesomeMarkers.icon({icon:"flag",markerColor:"orange",prefix:"fa"})}).bindPopup(containerPopup.html());_this6.indirectPointLayer[description]=L.featureGroup([marker]),map.addLayer(_this6.indirectPointLayer[description]);}),container.on("click",".removeIndirect",function(e){var currentTarget=$(e.currentTarget),container=currentTarget.closest(".indirectContainer");map.removeLayer(_this6.indirectPointLayer[container.find(".indirect").val()]),currentTarget.closest(".indirectContainer").remove();}),container.on("click",".moveUp",function(e){var currentTarget=$(e.currentTarget),container=currentTarget.closest(".indirectContainer"),previousElement=container.prev();previousElement.hasClass("startContainer")||previousElement.before(container);}),container.on("click",".moveDown",function(e){var currentTarget=$(e.currentTarget),container=currentTarget.closest(".indirectContainer"),nextElement=container.next();nextElement.hasClass("indirectTemplate")||nextElement.after(container);}),container.on("click",".searchInRadius",function(e){endIconLayer&&map.removeLayer(endIconLayer);var currentTarget=$(e.currentTarget),containerPopup=currentTarget.closest(".leaflet-popup-content"),coordinates=containerPopup.find(".coordinates"),progressIndicatorElement=jQuery.progressIndicator({position:container,blockInfo:{enabled:!0}}),params={module:"OpenStreetMap",action:"GetMarkers",srcModule:app.getModuleName(),radius:container.find(".radius").val(),lat:coordinates.data("lat"),lon:coordinates.data("lon"),cache:_this6.getCacheParamsToRequest()};params=$.extend(_this6.selectedParams,params),AppConnector.request(params).done(function(response){progressIndicatorElement.progressIndicator({mode:"hide"}),_this6.setMarkers(response.result);});});var descriptionContainer=container.find(".js-description-container");container.find(".js-calculate-route").on("click",function(){var indirectLon=[],indirectLat=[];container.find(".indirectContainer:not(.d-none) input.indirect").each(function(){var currentTarget=$(this);indirectLat.push(currentTarget.data("lat")),indirectLon.push(currentTarget.data("lon"));});var endElement=container.find(".end"),startElement=container.find(".start"),progressIndicatorElement=jQuery.progressIndicator({position:container,blockInfo:{enabled:!0}});AppConnector.request({url:"index.php",data:{module:"OpenStreetMap",action:"GetRoute",flon:startElement.data("lon"),flat:startElement.data("lat"),ilon:indirectLon,ilat:indirectLat,tlon:endElement.data("lon"),tlat:endElement.data("lat")}}).done(function(response){progressIndicatorElement.progressIndicator({mode:"hide"}),_this6.routeLayer&&map.removeLayer(_this6.routeLayer);var route=L.geoJson(response.result.geoJson);_this6.routeLayer=L.featureGroup([route]),map.addLayer(_this6.routeLayer),descriptionContainer.removeClass("d-none");var instruction=container.find(".js-instruction_block");response.result.properties.description?(instruction.removeClass("d-none"),descriptionContainer.find(".js-instruction_body").html(response.result.properties.description)):instruction.addClass("d-none"),descriptionContainer.find(".distance").html(App.Fields.Double.formatToDisplay(response.result.properties.distance)),descriptionContainer.find(".travelTime").html(App.Fields.Double.formatToDisplay(response.result.properties.traveltime/60));}).fail(function(error){progressIndicatorElement.progressIndicator({mode:"hide"}),app.showNotify({titleTrusted:!1,textTrusted:!1,title:app.vtranslate("JS_UNEXPECTED_ERROR"),text:error,type:"error"});});}),container.on("click",".setView",function(e){var currentTarget=$(e.currentTarget),inputInstance=currentTarget.closest(".input-group").find(".end,.start,.indirect"),lat=inputInstance.data("lat"),lon=inputInstance.data("lon");"undefined"==typeof lat&&"undefined"==typeof lon||map.setView(new L.LatLng(lat,lon),11);}),this.registerSearchCompany(),this.isPanelRegistered=!0;},registerModalView:function registerModalView(container){var _this7=this;this.container=container;var progress=jQuery.progressIndicator({position:container,blockInfo:{enabled:!0}});container.find("#mapid").css({height:$("body").height()-160}),this.registerMap([0,0],2).then(function(){_this7.registerBasicModal(),_this7.registerPanel(),AppConnector.request($.extend(_this7.selectedParams,{module:"OpenStreetMap",action:"GetMarkers",groupBy:"type",srcModule:app.getModuleName()})).done(function(response){progress.progressIndicator({mode:"hide"}),_this7.setMarkers(response.result);});});},getMarkerPopup:function getMarkerPopup(label,coordinates){var btn=!(2<arguments.length&&void 0!==arguments[2])||arguments[2],useCoordinateButton=!!(3<arguments.length&&void 0!==arguments[3])&&arguments[3],popup=document.createElement("div"),description=document.createElement("span");description.className="description",description.innerText=label;var coordinatesInput=document.createElement("input");coordinatesInput.type="hidden",coordinatesInput.className="coordinates",coordinatesInput.setAttribute("data-lat",coordinates.lat),coordinatesInput.setAttribute("data-lon",coordinates.lon),popup.append(description,document.createElement("br"),coordinatesInput),btn&&popup.insertAdjacentHTML("beforeend","\n\t\t\t\t\t<button class=\"btn btn-primary btn-xs startTrack marginTB3 mr-3\"><span class=\"fas  fa-truck\"></span> ".concat(app.vtranslate("JS_OSM_START"),"</button>\n\t\t\t\t\t<button class=\"btn btn-outline-primary btn-xs endTrack marginTB3\"><span class=\"fas fa-flag-checkered\"></span> ").concat(app.vtranslate("JS_OSM_END"),"</button><br>\n\t\t\t\t\t<button class=\"btn btn-outline-primary btn-xs indirectPoint marginTB3 mr-3\"><span class=\"fas fa-flag\"></span> ").concat(app.vtranslate("JS_OSM_INDIRECT_POINT"),"</button>\n\t\t\t\t\t<button class=\"btn btn-primary btn-xs searchInRadius marginTB3\"><span class=\"fas fa-arrows-to-dot mr-2\"></span> ").concat(app.vtranslate("JS_OSM_SEARCH_IN_RADIUS"),"</button>\n\t\t\t\t")),useCoordinateButton&&this.fieldInstance&&this.fieldInstance.hasOwnProperty("fieldInfo")&&0<Object.values(this.fieldInstance.fieldInfo).length&&popup.insertAdjacentHTML("beforeend","\n\t\t\t\t\t<button class=\"btn btn-primary btn-xs indirectPoint marginTB3 mr-3 js-use-coordinate\"><span class=\"fas fa-right-to-bracket\"></span> ".concat(app.vtranslate("JS_OSM_USE_COORDINATES"),"</button>\n\t\t\t\t"));var coordinatesSpan=document.createElement("span");return coordinatesSpan.classList.add("border","d-block","my-1","p-1"),coordinatesSpan.innerText="".concat(coordinates.lat,", ").concat(coordinates.lon),popup.append(coordinatesSpan),popup},registerDetailView:function registerDetailView(container){this.container=container;var coordinates=container.find("#coordinates").val();coordinates=JSON.parse(coordinates);var startCoordinate=[0,0],startZoom=2,$map=container.find("#mapid");coordinates.length&&(startCoordinate=coordinates[0],startZoom=6),$(".mainBody").length?1e3>$(".mainBody").height()?$map.height($(".mainBody").height()-($(".detailViewTitle").height()+$(".detailViewContainer .related").height()+25)):$map.height(1e3):1e3>$(".bodyContents").height()?$map.height($(".bodyContents").height()-($(".detailViewTitle").height()+$(".detailViewContainer .related").height()+25)):$map.height(1e3),this.registerMap(startCoordinate,startZoom).then(function(myMap){var markers=L.markerClusterGroup({maxClusterRadius:10});coordinates.forEach(function(e){markers.addLayer(L.marker([e.lat,e.lon],{icon:L.AwesomeMarkers.icon({icon:"home",markerColor:"blue",prefix:"fa",iconColor:e.color})}).bindPopup(e.label));}),myMap.addLayer(markers);});},registerFromField:function registerFromField(container,_fieldInstance){var _this8=this;this.container=container,this.fieldInstance=_fieldInstance,container.find("#mapid").css({height:$("body").height()-160});var decimalPoint=container.find(".js-point-decimal"),point=null,zoom=3,lat=0,lon=0;0<decimalPoint.length&&(point=JSON.parse(decimalPoint.val())),point&&(zoom=14,lat=point.lat,lon=point.lon),this.registerMap([lat,lon],zoom).then(function(){_this8.registerBasicModal(),_this8.layerMarkers=L.markerClusterGroup({maxClusterRadius:10}),point&&_this8.addMarker(point.lat,point.lon,_this8.getMarkerPopup("",{lat:point.lat,lon:point.lon},!1));}),container.on("click",".js-use-coordinate",function(e){if(_this8.fieldInstance){var currentTargetTrack=$(e.currentTarget),containerPopup=currentTargetTrack.closest(".leaflet-popup-content"),coordinates=containerPopup.find(".coordinates");_this8.fieldInstance.setValue({lat:coordinates.data("lat"),lon:coordinates.data("lon")},"decimal"),app.hideModalWindow(null,container.closest(".js-modal-container").attr("id"));}});},createMarkerIconFromResponse:function createMarkerIconFromResponse(response,markerColor){var _parts$,_parts$2,parts=response.hasOwnProperty("icon")?response.icon.split("-"):[];return L.AwesomeMarkers.icon({icon:null!==(_parts$=parts[1])&&void 0!==_parts$?_parts$:"home",markerColor:null!==markerColor&&void 0!==markerColor?markerColor:"cadetblue",iconColor:response.hasOwnProperty("color")?response.color:"#fff",prefix:null!==(_parts$2=parts[0])&&void 0!==_parts$2?_parts$2:"fa"})},addMarker:function addMarker(lat,lon,label,icon){icon||(icon=L.AwesomeMarkers.icon({icon:"home",markerColor:"cadetblue",prefix:"fa"}));var marker=L.marker([lat,lon],{icon:icon});label&&marker.bindPopup(label),this.layerMarkers.addLayer(marker),this.mapInstance.addLayer(this.layerMarkers);},_deferredPromise:function _deferredPromise(value){var resolve,reject,promise=new Promise(function(_resolve,_reject){resolve=_resolve,reject=_reject;});return promise.resolve=resolve,promise.reject=reject,promise.value=value,promise}});
//# sourceMappingURL=Map.min.js.map
