<?php

/**
 * Password Action Class.
 *
 * @package Settings.Action
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

use App\Encryption;

/**
 * Controller for password action in administration panel.
 */
class Settings_Vtiger_Password_Action extends Settings_Vtiger_Basic_Action
{
	use \App\Controller\ExposeMethod;

	/** {@inheritdoc} */
	public function __construct()
	{
		parent::__construct();
		$this->exposeMethod('getPwd');
	}

	/**
	 * Gets password.
	 *
	 * @param App\Request $request
	 */
	public function getPwd(App\Request $request)
	{
		$qualifiedModuleName = $request->getModule(false);
		$recordModelClass = Vtiger_Loader::getComponentClassName('Model', 'Record', $qualifiedModuleName);
		$pwd = '';
		if (method_exists($recordModelClass, 'getInstanceById')) {
			$recordId = $request->getInteger('record');
			$recordModel = $recordModelClass::getInstanceById($recordId);
			$passwordField = $request->getByType('field', \App\Purifier::ALNUM);
			$pwd = Encryption::getInstance()->decrypt($recordModel->get($passwordField));
			\Settings_Vtiger_Tracker_Model::setRecordId($recordId);
			\Settings_Vtiger_Tracker_Model::addBasic('show hidden data');
		}
		$response = new Vtiger_Response();
		$response->setResult(['success' => true, 'text' => $pwd]);
		$response->emit();
	}
}
