<?php
/**
 * YetiForce shop YetiForceWooCommerce file.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\YetiForce\Shop\Product;

use App\Language;
use App\Security\AdminAccess;
use App\YetiForce\Shop\AbstractBaseProduct;

/**
 * YetiForce shop YetiForceWooCommerce class.
 */
class YetiForceWooCommerce extends AbstractBaseProduct
{
	/** {@inheritdoc} */
	public function analyzeConfiguration(): array
	{
		if (empty($this->expirationDate) || \Settings_WooCommerce_Activation_Model::check()) {
			return [];
		}
		return [
			'message' => Language::translateArgs('LBL_FUNCTIONALITY_HAS_NOT_YET_BEEN_ACTIVATED', 'Settings:WooCommerce', 'WooCommerce'),
			'type' => 'LBL_REQUIRES_INTERVENTION',
			'href' => 'index.php?parent=Settings&module=WooCommerce&view=List',
		];
	}

	/** {@inheritdoc} */
	public function getAdditionalButtons(): array
	{
		$links = [];
		if ($this->website) {
			$links[] = \Vtiger_Link_Model::getInstanceFromValues([
				'linklabel' => 'Website',
				'relatedModuleName' => '_Base',
				'linkicon' => 'fas fa-globe mr-2',
				'linkhref' => true,
				'linkExternal' => true,
				'linktarget' => '_blank',
				'linkurl' => $this->website,
				'linkclass' => 'btn-outline-primary',
				'showLabel' => 1,
			]);
		}
		if (AdminAccess::isPermitted('WooCommerce')) {
			$links[] = \Vtiger_Link_Model::getInstanceFromValues([
				'linklabel' => 'LBL_WOOCOMMERCE',
				'relatedModuleName' => 'Settings:WooCommerce',
				'linkicon' => 'fa-solid fa-cash-register',
				'linkhref' => true,
				'linkurl' => 'index.php?parent=Settings&module=WooCommerce&view=List',
				'linkclass' => 'btn-primary',
				'showLabel' => 1,
			]);
		}

		return $links;
	}
}
