<?php
/**
 * Service for build filter used in Query Generator
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Builder;

use App\Report\Enums\Operator;
use App\Report\Model\Filter;
use App\Report\Model\FilterGroup;

/** FilterBuilder class */
final class FilterBuilder
{
	/** Build filter */
	public function build(array $data, FilterGroup $filterGroup): Filter
	{
		return new Filter(
			$data['filter_id'],
			$filterGroup,
			$data['value_1'],
			Operator::tryFrom($data['operator']),
			$data['value_2'],
		);
	}
}
