<?php
/**
 * ModTracker repository builder file
 *
 * @package \App\ModTracker
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mateusz Slominski <m.slominski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\ModTracker;

use App\Config;
use App\ModTracker\Repository\ModTrackerRepositoryInterface;

/**
 *  ModTracker repository builder class
 */
class Repository
{
	/**
	 * @var null|ModTrackerRepositoryInterface Cached repository instance
	 */
	private static ?ModTrackerRepositoryInterface $repositoryInstance = null;

	/**
	 * Returns repository instance
	 *
	 * @return ModTrackerRepositoryInterface
	 */
	public static function instance(): ModTrackerRepositoryInterface
	{
		if (self::$repositoryInstance === null) {
			self::$repositoryInstance = Config::db('mongo') && extension_loaded('mongodb')
				? new \App\ModTracker\Repository\Mongo\ModTrackerRepository(\App\Db\Mongo::getInstance('mongo'))
				: new \App\ModTracker\Repository\Relational\ModTrackerRepository(\App\Db::getInstance());
		}

		return self::$repositoryInstance;
	}

	/**
	 * Returns true whenever repository is using mongo implementation
	 *
	 * @return bool
	 */
	public static function isUsingMongo(): bool
	{
		return self::instance() instanceof \App\ModTracker\Repository\Mongo\ModTrackerRepository;
	}
}
