<?php
/**
 * Virtual query condition field file.
 *
 * @package UIType
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Conditions\QueryFields;

/**
 * Virtual query condition field class.
 */
class VirtualField extends BaseField
{
	/** {@inheritdoc} */
	public function getOrderBy($order = false): array
	{
		[$baseField , $refModuleName, $refFieldName] = explode('::', $this->fieldModel->getParam('virtualField'));
		$fieldDetail = [
			'relatedModule' => $refModuleName,
			'relatedField' => $refFieldName,
			'sourceField' => $baseField,
		];
		$field = $this->queryGenerator->addRelatedJoin($fieldDetail);
		if (!$field) {
			\App\Log::error('Not found virtual field');
		}
		return $this->queryGenerator->getQueryRelatedField($fieldDetail, $field)->getOrderBy($order);
	}
}
