<?php

/**
 * UIType Record Number Field Class.
 *
 * @package   UIType
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
class Vtiger_RecordNumber_UIType extends Vtiger_Base_UIType
{
	/** {@inheritdoc} */
	public function validate($value, $isUserFormat = false)
	{
		if (empty($value) || isset($this->validate[$value])) {
			return;
		}

		$this->validateFieldLength($value);

		$this->validate[$value] = true;
	}

	/** {@inheritdoc} */
	public function convertToSave($value, Vtiger_Record_Model $recordModel)
	{
		$recordNumberInstance = \App\Fields\RecordNumber::getInstance($recordModel->getModuleName());
		$recordNumberInstance->setRecord($recordModel);
		if ($recordNumberInstance->isNewSequence()) {
			$value = $recordNumberInstance->getIncrementNumber();
			$recordModel->set($this->getFieldModel()->getName(), $value);
		}
		return $value;
	}

	/** {@inheritdoc} */
	public function getDbConditionBuilderValue($value, string $operator)
	{
		return App\Purifier::decodeHtml($value);
	}

	/** {@inheritdoc} */
	public function getQueryOperators()
	{
		return ['e', 'n', 's', 'ew', 'c', 'k', 'y', 'ny'];
	}

	/** {@inheritdoc} */
	public function getDefaultOperator()
	{
		return 'a';
	}
}
