<?php

/**
 * Login password change view file.
 *
 * @package   View
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Exceptions\AppException;
use App\Purifier;
use App\Request;
use App\Session;
use App\Utils\Tokens;

/**
 * Login password change view class.
 */
class Users_LoginPassChange_View extends Users_Login_View
{
	/** {@inheritdoc} */
	public function process(Request $request)
	{
		$viewer = $this->getViewer($request);
		$bruteForceInstance = Settings_BruteForce_Module_Model::getCleanInstance();
		if ($bruteForceInstance->isActive() && $bruteForceInstance->isBlockedIp()) {
			$viewer->assign('MESSAGE', 'LBL_IP_IS_BLOCKED');
		} else {
			try {
				if ($request->isEmpty('token')) {
					throw new AppException('ERR_NO_TOKEN', 405);
				}
				$token = $request->getByType('token', Purifier::ALNUM);
				$tokenData = Tokens::get($token, Tokens::SKIP_COUNT_VERIFICATION);
				if (empty($tokenData)) {
					throw new AppException('ERR_TOKEN_DOES_NOT_EXIST', 405);
				}
				Session::set($token, $tokenData);
				$viewer->assign('TOKEN', $token);
			} catch (AppException $th) {
				if ($bruteForceInstance->isActive()) {
					$bruteForceInstance->incAttempts();
				}
				$viewer->assign('MESSAGE', $th->getDisplayMessage());
			}
		}
		$viewer->view('LoginPassChange.tpl', 'Users');
	}
}
