<?php
/*
 * Provider for not supported modules in Report module
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Provider;

use App\User;

/** RestrictedModulesProvider class */
final class RestrictedModulesProvider
{
	private const RESTRICTED_MODULES_FOR_REPORTS = [
		'Dashboard',
		'Home',
		'Import',
		'ModTracker',
		'Chat',
		'RecycleBin',
		'OSSMail',
		'OSSMailScanner',
		'OSSMailView',
	];

	/** Provide excluded modules names */
	public static function provide():array
	{
		return array_merge(
			self::RESTRICTED_MODULES_FOR_REPORTS,
			false === User::getCurrentUserModel()->isAdmin() ? ['Users'] : [],
		);
	}
}
