<?php
/**
 * Service for creating Report Template
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Builder;

use App\Report\Model\Template;

/** TemplateBuilder class */
final class TemplateBuilder
{
	public function __construct(
		private readonly QueryBuilder $queryBuilder,
	) {
	}

	/** Build template */
	public function build(array $data): Template
	{
		$template = $data[0];

		return new Template(
			$template['template_id'],
			$template['name'],
			$this->queryBuilder->build($data)
		);
	}
}
